/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.lang.reflect.Modifier;
import java.util.Set;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTStringLiteral;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LiteralsFirstInComparisonsRule
extends AbstractJavaRulechainRule {
    private static final Set<String> STRING_COMPARISONS = CollectionUtil.setOf((Object)"equalsIgnoreCase", (Object[])new String[]{"compareTo", "compareToIgnoreCase", "contentEquals"});

    public LiteralsFirstInComparisonsRule() {
        super(ASTMethodCall.class, new Class[0]);
    }

    @Override
    public Object visit(ASTMethodCall call, Object data) {
        if ("equals".equals(call.getMethodName()) && call.getArguments().size() == 1 && this.isEqualsObjectAndNotAnOverload(call)) {
            this.checkArgs((RuleContext)data, call);
        } else if (STRING_COMPARISONS.contains(call.getMethodName()) && call.getArguments().size() == 1 && TypeTestUtil.isDeclaredInClass(String.class, call.getMethodType())) {
            this.checkArgs((RuleContext)data, call);
        }
        return data;
    }

    private boolean isEqualsObjectAndNotAnOverload(ASTMethodCall call) {
        return call.getOverloadSelectionInfo().isFailed() || call.getMethodType().getFormalParameters().equals(CollectionUtil.listOf((Object)call.getTypeSystem().OBJECT, (Object[])new JClassType[0]));
    }

    private boolean isConstantString(JavaNode node) {
        if (node instanceof ASTAssignableExpr.ASTNamedReferenceExpr) {
            ASTAssignableExpr.ASTNamedReferenceExpr reference = (ASTAssignableExpr.ASTNamedReferenceExpr)node;
            @Nullable JFieldSymbol symbol = null;
            if (reference.getReferencedSym() instanceof JFieldSymbol) {
                symbol = (JFieldSymbol)reference.getReferencedSym();
            }
            if (symbol != null && symbol.isFinal() && Modifier.isStatic(symbol.getModifiers())) {
                return reference.getTypeMirror().getSymbol().equals(reference.getTypeSystem().getClassSymbol(String.class));
            }
        }
        return node instanceof ASTStringLiteral;
    }

    private void checkArgs(RuleContext ctx, ASTMethodCall call) {
        ASTExpression arg = (ASTExpression)call.getArguments().get(0);
        ASTExpression qualifier = call.getQualifier();
        if (!this.isConstantString(qualifier) && (arg instanceof ASTStringLiteral || this.isConstantString(arg))) {
            this.addViolation(ctx, (Node)call);
        }
    }
}

