/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.internal;

import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.metrics.MetricOptions;

public final class ClassFanOutVisitor
extends JavaVisitorBase<Set<JClassSymbol>, Void> {
    private static final ClassFanOutVisitor INCLUDE_JLANG = new ClassFanOutVisitor(true);
    private static final ClassFanOutVisitor EXCLUDE_JLANG = new ClassFanOutVisitor(false);
    private final boolean includeJavaLang;

    private ClassFanOutVisitor(boolean includeJavaLang) {
        this.includeJavaLang = includeJavaLang;
    }

    public static ClassFanOutVisitor getInstance(MetricOptions options) {
        if (options.getOptions().contains((Object)JavaMetrics.ClassFanOutOption.INCLUDE_JAVA_LANG)) {
            return INCLUDE_JLANG;
        }
        return EXCLUDE_JLANG;
    }

    @Override
    public Void visitExpression(ASTExpression node, Set<JClassSymbol> data) {
        this.check(node, data);
        return (Void)this.visitChildren((Node)node, data);
    }

    @Override
    public Void visit(ASTClassOrInterfaceType node, Set<JClassSymbol> data) {
        this.check(node, data);
        return (Void)this.visitChildren((Node)node, data);
    }

    private void check(TypeNode node, Set<JClassSymbol> classes) {
        JTypeMirror typeMirror = node.getTypeMirror();
        if (!(typeMirror instanceof JClassType)) {
            return;
        }
        JClassSymbol symbol = ((JClassType)typeMirror).getSymbol();
        if (this.shouldBeIncluded(symbol)) {
            classes.add(symbol);
        }
    }

    private boolean shouldBeIncluded(JClassSymbol classToCheck) {
        return this.includeJavaLang || !"java.lang".equals(classToCheck.getPackageName());
    }
}

