/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.typeresolution.internal;

public interface NullableClassLoader {
    public Class<?> loadClassOrNull(String var1);

    public static class ClassLoaderWrapper
    implements NullableClassLoader {
        private final ClassLoader classLoader;

        private ClassLoaderWrapper(ClassLoader classLoader) {
            assert (classLoader != null) : "Null classloader";
            this.classLoader = classLoader;
        }

        @Override
        public Class<?> loadClassOrNull(String binaryName) {
            try {
                return this.classLoader.loadClass(binaryName);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public static ClassLoaderWrapper wrapNullable(ClassLoader classLoader) {
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            return new ClassLoaderWrapper(classLoader);
        }
    }
}

