/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.impl.internal;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssertStatement;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCatchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabeledRule;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.lang.java.metrics.impl.CycloMetric;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import org.apache.commons.lang3.mutable.MutableInt;

public class CycloVisitor
extends JavaParserVisitorAdapter {
    protected final boolean considerBooleanPaths;
    protected final boolean considerAssert;
    private final JavaNode topNode;

    public CycloVisitor(MetricOptions options, JavaNode topNode) {
        this.considerBooleanPaths = !options.getOptions().contains((Object)CycloMetric.CycloOption.IGNORE_BOOLEAN_PATHS);
        this.considerAssert = options.getOptions().contains((Object)CycloMetric.CycloOption.CONSIDER_ASSERT);
        this.topNode = topNode;
    }

    @Override
    public final Object visit(JavaNode localNode, Object data) {
        return localNode.isFindBoundary() && !localNode.equals(this.topNode) ? data : super.visit(localNode, data);
    }

    @Override
    public Object visit(ASTSwitchExpression node, Object data) {
        return this.handleSwitch(node, (MutableInt)data);
    }

    @Override
    public Object visit(ASTSwitchStatement node, Object data) {
        return this.handleSwitch(node, (MutableInt)data);
    }

    private Object handleSwitch(JavaNode node, MutableInt data) {
        if (this.considerBooleanPaths) {
            data.add(CycloMetric.booleanExpressionComplexity((Node)node.getChild(0)));
        }
        for (ASTSwitchLabel label : node.findChildrenOfType(ASTSwitchLabel.class)) {
            if (label.isDefault()) continue;
            if (this.considerBooleanPaths) {
                data.add(label.findChildrenOfType(ASTExpression.class).size());
                continue;
            }
            if (node.getNumChildren() <= 1 + label.getIndexInParent() || !(node.getChild(label.getIndexInParent() + 1) instanceof ASTBlockStatement)) continue;
            data.increment();
        }
        for (ASTSwitchLabeledRule rule : node.findChildrenOfType(ASTSwitchLabeledRule.class)) {
            ASTSwitchLabel label = (ASTSwitchLabel)rule.getFirstChildOfType(ASTSwitchLabel.class);
            if (label.isDefault() || !this.considerBooleanPaths) continue;
            data.add(label.findChildrenOfType(ASTExpression.class).size());
        }
        return this.visit(node, (Object)data);
    }

    @Override
    public Object visit(ASTConditionalExpression node, Object data) {
        ((MutableInt)data).increment();
        if (this.considerBooleanPaths) {
            ((MutableInt)data).add(CycloMetric.booleanExpressionComplexity((Node)node.getCondition()));
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTWhileStatement node, Object data) {
        ((MutableInt)data).increment();
        if (this.considerBooleanPaths) {
            ((MutableInt)data).add(CycloMetric.booleanExpressionComplexity((Node)node.getCondition()));
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        ((MutableInt)data).increment();
        if (this.considerBooleanPaths) {
            ((MutableInt)data).add(CycloMetric.booleanExpressionComplexity((Node)node.getCondition()));
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTForStatement node, Object data) {
        ((MutableInt)data).increment();
        if (this.considerBooleanPaths && !node.isForeach()) {
            ((MutableInt)data).add(CycloMetric.booleanExpressionComplexity((Node)node.getCondition()));
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTDoStatement node, Object data) {
        ((MutableInt)data).increment();
        if (this.considerBooleanPaths) {
            ((MutableInt)data).add(CycloMetric.booleanExpressionComplexity((Node)node.getCondition()));
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTCatchStatement node, Object data) {
        ((MutableInt)data).increment();
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTThrowStatement node, Object data) {
        ((MutableInt)data).increment();
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTAssertStatement node, Object data) {
        if (this.considerAssert) {
            ((MutableInt)data).add(2);
            if (this.considerBooleanPaths) {
                ((MutableInt)data).add(CycloMetric.booleanExpressionComplexity((Node)node.getCondition()));
            }
        }
        return super.visit(node, data);
    }
}

