/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.rule.AbstractLombokAwareRule;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.ScopedNode;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class SingularFieldRule
extends AbstractLombokAwareRule {
    private static final PropertyDescriptor<Boolean> CHECK_INNER_CLASSES = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkInnerClasses").defaultValue((Object)false)).desc("Check inner classes")).build();
    private static final PropertyDescriptor<Boolean> DISALLOW_NOT_ASSIGNMENT = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"disallowNotAssignment").defaultValue((Object)false)).desc("Disallow violations where the first usage is not an assignment")).build();

    public SingularFieldRule() {
        this.definePropertyDescriptor(CHECK_INNER_CLASSES);
        this.definePropertyDescriptor(DISALLOW_NOT_ASSIGNMENT);
    }

    @Override
    protected Collection<String> defaultSuppressionAnnotations() {
        ArrayList<String> defaultValues = new ArrayList<String>();
        defaultValues.addAll(super.defaultSuppressionAnnotations());
        defaultValues.add("lombok.experimental.Delegate");
        return defaultValues;
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        boolean checkInnerClasses = (Boolean)this.getProperty(CHECK_INNER_CLASSES);
        boolean disallowNotAssignment = (Boolean)this.getProperty(DISALLOW_NOT_ASSIGNMENT);
        if (node.isPrivate() && !node.isStatic() && !this.hasClassLombokAnnotation() && !this.hasIgnoredAnnotation(node)) {
            for (ASTVariableDeclarator declarator : node.findChildrenOfType(ASTVariableDeclarator.class)) {
                ASTVariableDeclaratorId declaration = (ASTVariableDeclaratorId)declarator.jjtGetChild(0);
                List<NameOccurrence> usages = declaration.getUsages();
                Node decl = null;
                boolean violation = true;
                for (int ix = 0; ix < usages.size(); ++ix) {
                    ASTClassOrInterfaceDeclaration clazz;
                    NameOccurrence no = usages.get(ix);
                    ScopedNode location = no.getLocation();
                    ASTPrimaryExpression primaryExpressionParent = (ASTPrimaryExpression)location.getFirstParentOfType(ASTPrimaryExpression.class);
                    if (ix == 0 && !disallowNotAssignment) {
                        if (primaryExpressionParent.getFirstParentOfType(ASTIfStatement.class) != null) {
                            violation = false;
                            break;
                        }
                        Node potentialStatement = primaryExpressionParent.jjtGetParent();
                        boolean assignmentToField = no.getImage().equals(location.getImage());
                        if (!assignmentToField || !this.isInAssignment(potentialStatement)) {
                            violation = false;
                            break;
                        }
                        if (usages.size() > ix + 1) {
                            ScopedNode secondUsageLocation = usages.get(ix + 1).getLocation();
                            List parentStatements = secondUsageLocation.getParentsOfType(ASTStatementExpression.class);
                            for (ASTStatementExpression statementExpression : parentStatements) {
                                if (statementExpression == null || !statementExpression.equals(potentialStatement)) continue;
                                violation = false;
                                break;
                            }
                        }
                    }
                    if (!checkInnerClasses && (clazz = (ASTClassOrInterfaceDeclaration)location.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class)) != null && clazz.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class) != null) {
                        violation = false;
                        break;
                    }
                    if (primaryExpressionParent.jjtGetParent() instanceof ASTSynchronizedStatement) {
                        violation = false;
                        break;
                    }
                    if (location.getFirstParentOfType(ASTLambdaExpression.class) != null) {
                        violation = false;
                        break;
                    }
                    Node method = (Node)location.getFirstParentOfType(ASTMethodDeclaration.class);
                    if (method == null && (method = (Node)location.getFirstParentOfType(ASTConstructorDeclaration.class)) == null && (method = (Node)location.getFirstParentOfType(ASTInitializer.class)) == null) continue;
                    if (decl == null) {
                        decl = method;
                        continue;
                    }
                    if (decl == method || decl.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class) != method.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class)) continue;
                    violation = false;
                    break;
                }
                if (!violation || usages.isEmpty()) continue;
                this.addViolation(data, node, new Object[]{declaration.getImage()});
            }
        }
        return data;
    }

    private boolean isInAssignment(Node potentialStatement) {
        if (potentialStatement instanceof ASTStatementExpression) {
            ASTStatementExpression statement = (ASTStatementExpression)potentialStatement;
            List assignments = statement.findDescendantsOfType(ASTAssignmentOperator.class);
            return !assignments.isEmpty() && "=".equals(((ASTAssignmentOperator)assignments.get(0)).getImage());
        }
        return false;
    }
}

