/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.multithreading;

import java.text.Format;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.typeresolution.TypeHelper;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.ScopedNode;

public class UnsynchronizedStaticFormatterRule
extends AbstractJavaRule {
    private Class<?> formatterClassToCheck = Format.class;

    public UnsynchronizedStaticFormatterRule() {
        this.addRuleChainVisit(ASTFieldDeclaration.class);
    }

    UnsynchronizedStaticFormatterRule(Class<?> formatterClassToCheck) {
        this();
        this.formatterClassToCheck = formatterClassToCheck;
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        if (!node.isStatic()) {
            return data;
        }
        ASTClassOrInterfaceType cit = (ASTClassOrInterfaceType)node.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
        if (cit == null || !TypeHelper.isA((TypeNode)cit, this.formatterClassToCheck)) {
            return data;
        }
        ASTVariableDeclaratorId var = (ASTVariableDeclaratorId)node.getFirstDescendantOfType(ASTVariableDeclaratorId.class);
        for (NameOccurrence occ : var.getUsages()) {
            ASTMethodDeclaration method;
            ScopedNode n = occ.getLocation();
            if (n.getFirstParentOfType(ASTSynchronizedStatement.class) != null || !n.getImage().contains(".") || (method = (ASTMethodDeclaration)n.getFirstParentOfType(ASTMethodDeclaration.class)) == null || method.isSynchronized()) continue;
            this.addViolation(data, (Node)n);
        }
        return data;
    }
}

