/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.multithreading;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSynchronizedStatement;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class DoubleCheckedLockingRule
extends AbstractJavaRule {
    private List<String> volatileFields;

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTCompilationUnit compilationUnit, Object data) {
        if (this.volatileFields == null) {
            this.volatileFields = new ArrayList<String>(0);
        } else {
            this.volatileFields.clear();
        }
        return super.visit(compilationUnit, data);
    }

    @Override
    public Object visit(ASTFieldDeclaration fieldDeclaration, Object data) {
        if (fieldDeclaration.isVolatile()) {
            for (ASTVariableDeclaratorId declarator : fieldDeclaration.findDescendantsOfType(ASTVariableDeclaratorId.class)) {
                this.volatileFields.add(declarator.getImage());
            }
        }
        return super.visit(fieldDeclaration, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        ASTPrimaryExpression pe;
        ASTStatementExpression se;
        List sel;
        ASTIfStatement is2;
        ASTSynchronizedStatement ss;
        List ssl;
        ASTIfStatement is;
        if (node.getResultType().isVoid()) {
            return super.visit(node, data);
        }
        ASTType typeNode = (ASTType)node.getResultType().jjtGetChild(0);
        if (typeNode.jjtGetNumChildren() == 0 || !(typeNode.jjtGetChild(0) instanceof ASTReferenceType)) {
            return super.visit(node, data);
        }
        List rsl = node.findDescendantsOfType(ASTReturnStatement.class);
        if (rsl.size() != 1) {
            return super.visit(node, data);
        }
        ASTReturnStatement rs = (ASTReturnStatement)rsl.get(0);
        List pel = rs.findDescendantsOfType(ASTPrimaryExpression.class);
        ASTPrimaryExpression ape = (ASTPrimaryExpression)pel.get(0);
        Node lastChild = ape.jjtGetChild(ape.jjtGetNumChildren() - 1);
        String returnVariableName = null;
        if (lastChild instanceof ASTPrimaryPrefix) {
            returnVariableName = this.getNameFromPrimaryPrefix((ASTPrimaryPrefix)lastChild);
        }
        if (returnVariableName == null || this.volatileFields.contains(returnVariableName)) {
            return super.visit(node, data);
        }
        if (this.checkLocalVariableUsage(node, returnVariableName)) {
            return super.visit(node, data);
        }
        List isl = node.findDescendantsOfType(ASTIfStatement.class);
        if (isl.size() == 2 && this.ifVerify(is = (ASTIfStatement)isl.get(0), returnVariableName) && (ssl = is.findDescendantsOfType(ASTSynchronizedStatement.class)).size() == 1 && (isl = (ss = (ASTSynchronizedStatement)ssl.get(0)).findDescendantsOfType(ASTIfStatement.class)).size() == 1 && this.ifVerify(is2 = (ASTIfStatement)isl.get(0), returnVariableName) && (sel = is2.findDescendantsOfType(ASTStatementExpression.class)).size() == 1 && (se = (ASTStatementExpression)sel.get(0)).jjtGetNumChildren() == 3 && se.jjtGetChild(0) instanceof ASTPrimaryExpression && this.matchName(pe = (ASTPrimaryExpression)se.jjtGetChild(0), returnVariableName) && se.jjtGetChild(1) instanceof ASTAssignmentOperator) {
            this.addViolation(data, node);
        }
        return super.visit(node, data);
    }

    private boolean checkLocalVariableUsage(ASTMethodDeclaration node, String returnVariableName) {
        List locals = node.findDescendantsOfType(ASTLocalVariableDeclaration.class);
        ASTVariableInitializer initializer = null;
        for (ASTLocalVariableDeclaration l : locals) {
            ASTVariableDeclaratorId id = (ASTVariableDeclaratorId)l.getFirstDescendantOfType(ASTVariableDeclaratorId.class);
            if (id == null || !id.hasImageEqualTo(returnVariableName)) continue;
            initializer = (ASTVariableInitializer)l.getFirstDescendantOfType(ASTVariableInitializer.class);
            break;
        }
        if (initializer == null) {
            return false;
        }
        if (initializer.jjtGetNumChildren() > 0 && initializer.jjtGetChild(0) instanceof ASTExpression && initializer.jjtGetChild(0).jjtGetNumChildren() > 0 && initializer.jjtGetChild(0).jjtGetChild(0) instanceof ASTPrimaryExpression && initializer.jjtGetChild(0).jjtGetChild(0).jjtGetNumChildren() > 0 && initializer.jjtGetChild(0).jjtGetChild(0).jjtGetChild(0) instanceof ASTPrimaryPrefix && initializer.jjtGetChild(0).jjtGetChild(0).jjtGetChild(0).jjtGetNumChildren() > 0 && initializer.jjtGetChild(0).jjtGetChild(0).jjtGetChild(0).jjtGetChild(0) instanceof ASTName) {
            ASTName name = (ASTName)initializer.jjtGetChild(0).jjtGetChild(0).jjtGetChild(0).jjtGetChild(0);
            if (name == null || !this.volatileFields.contains(name.getImage())) {
                return false;
            }
        } else {
            return false;
        }
        List names = node.findDescendantsOfType(ASTName.class);
        for (ASTName n : names) {
            ASTName value;
            Node expression;
            if (!n.hasImageEqualTo(returnVariableName) || (expression = n.getNthParent(3)) instanceof ASTEqualityExpression || !(expression instanceof ASTStatementExpression) || expression.jjtGetNumChildren() <= 2 || !(expression.jjtGetChild(1) instanceof ASTAssignmentOperator) || (value = (ASTName)expression.jjtGetChild(2).getFirstDescendantOfType(ASTName.class)) != null && this.volatileFields.contains(value.getImage())) continue;
            return false;
        }
        return true;
    }

    private boolean ifVerify(ASTIfStatement is, String varname) {
        ASTLiteral lit;
        ASTPrimaryPrefix pp2;
        ASTPrimaryExpression nullStmt;
        List finder = is.findDescendantsOfType(ASTPrimaryExpression.class);
        return finder.size() > 1 && (nullStmt = this.findNonVariableStmt(varname, (ASTPrimaryExpression)finder.get(0), (ASTPrimaryExpression)finder.get(1))) != null && nullStmt.jjtGetNumChildren() == 1 && nullStmt.jjtGetChild(0) instanceof ASTPrimaryPrefix && (pp2 = (ASTPrimaryPrefix)nullStmt.jjtGetChild(0)).jjtGetNumChildren() == 1 && pp2.jjtGetChild(0) instanceof ASTLiteral && (lit = (ASTLiteral)pp2.jjtGetChild(0)).jjtGetNumChildren() == 1 && lit.jjtGetChild(0) instanceof ASTNullLiteral;
    }

    private ASTPrimaryExpression findNonVariableStmt(String variableName, ASTPrimaryExpression apeLeft, ASTPrimaryExpression apeRight) {
        if (this.matchName(apeLeft, variableName)) {
            return apeRight;
        }
        if (this.matchName(apeRight, variableName)) {
            return apeLeft;
        }
        return null;
    }

    private boolean matchName(ASTPrimaryExpression ape, String name) {
        ASTPrimaryPrefix pp;
        String name2;
        return ape.jjtGetNumChildren() == 1 && ape.jjtGetChild(0) instanceof ASTPrimaryPrefix && (name2 = this.getNameFromPrimaryPrefix(pp = (ASTPrimaryPrefix)ape.jjtGetChild(0))) != null && name2.equals(name);
    }

    private String getNameFromPrimaryPrefix(ASTPrimaryPrefix pp) {
        if (pp.jjtGetNumChildren() == 1 && pp.jjtGetChild(0) instanceof ASTName) {
            return ((ASTName)pp.jjtGetChild(0)).getImage();
        }
        return null;
    }
}

