/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.QualifiedName;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTType;

public final class JavaQualifiedName
implements QualifiedName {
    private static final Pattern FORMAT = Pattern.compile("((\\w+\\.)+|\\.)              # packages\n(                         # classes\n  (\\w+)                  # primary class\n  (    \\$                   # separator\n    (\\d+)?               # optional local class index\n    \\w+  )*)(                         # optional operation suffix\n  \\#  (\\w+)                  # method name\n  \\(    (                     # parameters\n      (\\w+)      (,\\040\\w+)*        #   is a space\n    )?  \\))?", 4);
    private static final int PACKAGES_GROUP_INDEX = 1;
    private static final int CLASSES_GROUP_INDEX = 3;
    private static final int OPERATION_GROUP_INDEX = 7;
    private static final int PARAMETERS_GROUP_INDEX = 9;
    private static final int NOTLOCAL_PLACEHOLDER = -1;
    private static final Map<JavaQualifiedName, Map<String, Integer>> LOCAL_INDICES = new WeakHashMap<JavaQualifiedName, Map<String, Integer>>();
    private static final Pattern LOCAL_INDEX_PATTERN = Pattern.compile("(\\d+)(\\w+)");
    private String[] packages = null;
    private String[] classes = new String[1];
    private String operation = null;
    private int[] localIndices = new int[1];

    private JavaQualifiedName() {
        this.localIndices[0] = -1;
    }

    static void resetLocalIndicesCounter() {
        LOCAL_INDICES.clear();
    }

    static JavaQualifiedName ofOperation(ASTMethodDeclaration node) {
        JavaQualifiedName parentQname = ((ASTAnyTypeDeclaration)node.getFirstParentOfType(ASTAnyTypeDeclaration.class)).getQualifiedName();
        return JavaQualifiedName.ofOperation(parentQname, node.getMethodName(), (ASTFormalParameters)node.getFirstDescendantOfType(ASTFormalParameters.class));
    }

    static JavaQualifiedName ofOperation(ASTConstructorDeclaration node) {
        ASTAnyTypeDeclaration parent = (ASTAnyTypeDeclaration)node.getFirstParentOfType(ASTAnyTypeDeclaration.class);
        return JavaQualifiedName.ofOperation(parent.getQualifiedName(), parent.getImage(), (ASTFormalParameters)node.getFirstDescendantOfType(ASTFormalParameters.class));
    }

    private static JavaQualifiedName ofOperation(JavaQualifiedName parent, String opName, ASTFormalParameters params) {
        JavaQualifiedName qname = new JavaQualifiedName();
        qname.packages = parent.packages;
        qname.classes = parent.classes;
        qname.operation = JavaQualifiedName.getOperationName(opName, params);
        return qname;
    }

    static JavaQualifiedName ofNestedClass(JavaQualifiedName parent, String className) {
        return JavaQualifiedName.nestedOrLocalClassQualifiedNameHelper(parent, className, -1);
    }

    static JavaQualifiedName ofLocalClass(JavaQualifiedName parent, String className) {
        return JavaQualifiedName.nestedOrLocalClassQualifiedNameHelper(parent, className, JavaQualifiedName.addLocal(parent, className));
    }

    private static JavaQualifiedName nestedOrLocalClassQualifiedNameHelper(JavaQualifiedName parent, String className, int localIndex) {
        JavaQualifiedName toBuild = new JavaQualifiedName();
        toBuild.packages = parent.packages;
        toBuild.classes = Arrays.copyOf(parent.classes, parent.classes.length + 1);
        toBuild.classes[parent.classes.length] = className;
        toBuild.localIndices = Arrays.copyOf(parent.localIndices, parent.localIndices.length + 1);
        toBuild.localIndices[parent.localIndices.length] = localIndex;
        return toBuild;
    }

    private static int addLocal(JavaQualifiedName parent, String localClassName) {
        Map<String, Integer> siblings = LOCAL_INDICES.get(parent);
        if (siblings == null) {
            LOCAL_INDICES.put(parent, new HashMap());
            LOCAL_INDICES.get(parent).put(localClassName, 1);
            return 1;
        }
        Integer count = siblings.get(localClassName);
        if (count == null) {
            siblings.put(localClassName, 1);
            return 1;
        }
        siblings.put(localClassName, count + 1);
        return count + 1;
    }

    static JavaQualifiedName ofOuterClass(ASTAnyTypeDeclaration node) {
        ASTPackageDeclaration pkg = (ASTPackageDeclaration)((ASTCompilationUnit)node.getFirstParentOfType(ASTCompilationUnit.class)).getFirstChildOfType(ASTPackageDeclaration.class);
        JavaQualifiedName qname = new JavaQualifiedName();
        qname.packages = pkg == null ? null : pkg.getPackageNameImage().split("\\.");
        qname.classes[0] = node.getImage();
        return qname;
    }

    public static JavaQualifiedName ofClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        String name = clazz.getName();
        if (name.indexOf(46) < 0) {
            name = '.' + name;
        }
        return JavaQualifiedName.ofString(name);
    }

    public static JavaQualifiedName ofString(String name) {
        JavaQualifiedName qname = new JavaQualifiedName();
        Matcher matcher = FORMAT.matcher(name);
        if (!matcher.matches()) {
            return null;
        }
        qname.packages = ".".equals(matcher.group(1)) ? null : matcher.group(1).split("\\.");
        qname.operation = matcher.group(7) == null ? null : matcher.group(7).substring(1);
        qname.classes = matcher.group(3).split("\\$");
        qname.localIndices = new int[qname.classes.length];
        for (int i = 0; i < qname.classes.length; ++i) {
            Matcher localIndexMatcher = LOCAL_INDEX_PATTERN.matcher(qname.classes[i]);
            if (localIndexMatcher.matches()) {
                qname.localIndices[i] = Integer.parseInt(localIndexMatcher.group(1));
                qname.classes[i] = localIndexMatcher.group(2);
                continue;
            }
            qname.localIndices[i] = -1;
        }
        return qname;
    }

    private static String getOperationName(String methodName, ASTFormalParameters params) {
        StringBuilder sb = new StringBuilder();
        sb.append(methodName);
        sb.append('(');
        int last = params.getParameterCount() - 1;
        for (int i = 0; i < last; ++i) {
            sb.append(((ASTType)params.jjtGetChild(i).getFirstDescendantOfType(ASTType.class)).getTypeImage());
            sb.append(", ");
        }
        if (last > -1) {
            sb.append(((ASTType)params.jjtGetChild(last).getFirstDescendantOfType(ASTType.class)).getTypeImage());
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean isClass() {
        return this.classes[0] != null && this.operation == null;
    }

    public boolean isOperation() {
        return this.operation != null;
    }

    public boolean isLocalClass() {
        return this.localIndices[this.localIndices.length - 1] != -1;
    }

    public String[] getPackages() {
        return this.packages == null ? null : Arrays.copyOf(this.packages, this.packages.length);
    }

    public String[] getClasses() {
        return Arrays.copyOf(this.classes, this.classes.length);
    }

    public String getOperation() {
        return this.operation;
    }

    public JavaQualifiedName getClassName() {
        if (this.isClass()) {
            return this;
        }
        JavaQualifiedName qname = new JavaQualifiedName();
        qname.classes = this.classes;
        qname.packages = this.packages;
        return qname;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaQualifiedName that = (JavaQualifiedName)o;
        return Arrays.equals(this.packages, that.packages) && Arrays.equals(this.classes, that.classes) && Objects.equals(this.operation, that.operation) && Arrays.equals(this.localIndices, that.localIndices);
    }

    public int hashCode() {
        int result = Objects.hash(this.operation);
        result = 31 * result + Arrays.hashCode(this.packages);
        result = 31 * result + Arrays.hashCode(this.classes);
        result = 31 * result + Arrays.hashCode(this.localIndices);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.packages != null) {
            int last = this.packages.length - 1;
            for (int i = 0; i < last; ++i) {
                sb.append(this.packages[i]).append('.');
            }
            sb.append(this.packages[last]);
        }
        sb.append('.');
        sb.append(this.classes[0]);
        for (int i = 1; i < this.classes.length; ++i) {
            sb.append('$');
            if (this.localIndices[i] != -1) {
                sb.append(this.localIndices[i]);
            }
            sb.append(this.classes[i]);
        }
        if (this.operation != null) {
            sb.append('#').append(this.operation);
        }
        return sb.toString();
    }
}

