/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.oom.signature;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.lang.java.oom.signature.OperationSignature;
import net.sourceforge.pmd.lang.java.oom.signature.SigMask;

public final class OperationSigMask
extends SigMask<OperationSignature> {
    private Set<OperationSignature.Role> roleMask = new HashSet<OperationSignature.Role>();
    private boolean coverAbstract = false;

    public OperationSigMask() {
        this.coverAllRoles();
    }

    public void restrictRolesTo(OperationSignature.Role ... roles) {
        this.roleMask.clear();
        this.roleMask.addAll(Arrays.asList(roles));
    }

    public void coverAllRoles() {
        this.roleMask.addAll(Arrays.asList(OperationSignature.Role.values()));
    }

    public void forbid(OperationSignature.Role ... roles) {
        this.roleMask.removeAll(Arrays.asList(roles));
    }

    public void coverAbstract(boolean coverAbstract) {
        this.coverAbstract = coverAbstract;
    }

    @Override
    public boolean covers(OperationSignature sig) {
        return super.covers(sig) && this.roleMask.contains((Object)sig.role) && (this.coverAbstract || !sig.isAbstract);
    }
}

