/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTBooleanLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExtendsList;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTImplementsList;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTTypeParameter;
import net.sourceforge.pmd.lang.java.ast.ASTTypeParameters;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.symboltable.AbstractJavaScope;
import net.sourceforge.pmd.lang.java.symboltable.Applier;
import net.sourceforge.pmd.lang.java.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.SimpleTypedNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.SourceFileScope;
import net.sourceforge.pmd.lang.java.symboltable.TypedNameDeclaration;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.lang.symboltable.Scope;

public class ClassScope
extends AbstractJavaScope {
    private static ThreadLocal<Integer> anonymousInnerClassCounter = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 1;
        }
    };
    private String className;
    private boolean isEnum;

    public ClassScope(String className) {
        this.className = className;
        anonymousInnerClassCounter.set(1);
    }

    public ClassScope() {
        int v = anonymousInnerClassCounter.get();
        this.className = "Anonymous$" + v;
        anonymousInnerClassCounter.set(v + 1);
    }

    public void setIsEnum(boolean isEnum) {
        this.isEnum = isEnum;
    }

    public Map<ClassNameDeclaration, List<NameOccurrence>> getClassDeclarations() {
        return this.getDeclarations(ClassNameDeclaration.class);
    }

    public Map<MethodNameDeclaration, List<NameOccurrence>> getMethodDeclarations() {
        return this.getDeclarations(MethodNameDeclaration.class);
    }

    public Map<VariableNameDeclaration, List<NameOccurrence>> getVariableDeclarations() {
        return this.getDeclarations(VariableNameDeclaration.class);
    }

    public NameDeclaration addNameOccurrence(NameOccurrence occurrence) {
        JavaNameOccurrence javaOccurrence = (JavaNameOccurrence)occurrence;
        NameDeclaration decl = this.findVariableHere(javaOccurrence);
        if (decl != null && (javaOccurrence.isMethodOrConstructorInvocation() || javaOccurrence.isMethodReference())) {
            List<NameOccurrence> nameOccurrences = this.getMethodDeclarations().get(decl);
            if (nameOccurrences != null) {
                nameOccurrences.add(javaOccurrence);
                JavaNode n = javaOccurrence.getLocation();
                if (n instanceof ASTName) {
                    ((ASTName)n).setNameDeclaration(decl);
                }
            }
        } else if (decl != null && !javaOccurrence.isThisOrSuper()) {
            List<NameOccurrence> nameOccurrences = this.getVariableDeclarations().get(decl);
            if (nameOccurrences == null) {
                for (ClassNameDeclaration innerClass : this.getClassDeclarations().keySet()) {
                    Scope innerClassScope = innerClass.getScope();
                    if (!innerClassScope.contains((NameOccurrence)javaOccurrence)) continue;
                    innerClassScope.addNameOccurrence((NameOccurrence)javaOccurrence);
                }
            } else {
                nameOccurrences.add(javaOccurrence);
                JavaNode n = javaOccurrence.getLocation();
                if (n instanceof ASTName) {
                    ((ASTName)n).setNameDeclaration(decl);
                }
            }
        }
        return decl;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    protected NameDeclaration findVariableHere(JavaNameOccurrence occurrence) {
        Map<MethodNameDeclaration, List<NameOccurrence>> methodDeclarations = this.getMethodDeclarations();
        Map<VariableNameDeclaration, List<NameOccurrence>> variableDeclarations = this.getVariableDeclarations();
        if (occurrence.isThisOrSuper() || occurrence.getImage() != null && occurrence.getImage().equals(this.className)) {
            if (variableDeclarations.isEmpty() && methodDeclarations.isEmpty()) {
                return null;
            }
            if (!variableDeclarations.isEmpty()) {
                return (NameDeclaration)variableDeclarations.keySet().iterator().next();
            }
            return (NameDeclaration)methodDeclarations.keySet().iterator().next();
        }
        if (occurrence.isMethodOrConstructorInvocation()) {
            for (MethodNameDeclaration mnd : methodDeclarations.keySet()) {
                if (!mnd.getImage().equals(occurrence.getImage())) continue;
                List<TypedNameDeclaration> parameterTypes = this.determineParameterTypes(mnd);
                List<TypedNameDeclaration> argumentTypes = this.determineArgumentTypes(occurrence, parameterTypes);
                if (!(mnd.isVarargs() || occurrence.getArgumentCount() != mnd.getParameterCount() || ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).hasAuxclasspath() && !((Object)parameterTypes).equals(argumentTypes))) {
                    return mnd;
                }
                if (!mnd.isVarargs()) continue;
                int varArgIndex = parameterTypes.size() - 1;
                TypedNameDeclaration varArgType = parameterTypes.get(varArgIndex);
                if (varArgIndex != 0 && argumentTypes.size() < varArgIndex || ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).hasAuxclasspath() && !((Object)parameterTypes.subList(0, varArgIndex)).equals(argumentTypes.subList(0, varArgIndex))) continue;
                if (!((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).hasAuxclasspath()) {
                    return mnd;
                }
                boolean sameType = true;
                for (int i = varArgIndex; i < argumentTypes.size(); ++i) {
                    if (varArgType.equals(argumentTypes.get(i))) continue;
                    sameType = false;
                    break;
                }
                if (!sameType) continue;
                return mnd;
            }
            if (this.isEnum && "valueOf".equals(occurrence.getImage())) {
                return this.createBuiltInMethodDeclaration("valueOf", 1);
            }
            return null;
        }
        if (occurrence.isMethodReference()) {
            for (MethodNameDeclaration mnd : methodDeclarations.keySet()) {
                if (!mnd.getImage().equals(occurrence.getImage())) continue;
                return mnd;
            }
            return null;
        }
        ArrayList<String> images = new ArrayList<String>();
        if (occurrence.getImage() != null) {
            images.add(occurrence.getImage());
            if (occurrence.getImage().startsWith(this.className)) {
                images.add(this.clipClassName(occurrence.getImage()));
            }
        }
        ImageFinderFunction finder = new ImageFinderFunction(images);
        Applier.apply(finder, variableDeclarations.keySet().iterator());
        NameDeclaration result = finder.getDecl();
        Map<ClassNameDeclaration, List<NameOccurrence>> classDeclarations = this.getClassDeclarations();
        if (result == null && !classDeclarations.isEmpty()) {
            for (ClassNameDeclaration innerClass : this.getClassDeclarations().keySet()) {
                Applier.apply(finder, innerClass.getScope().getDeclarations().keySet().iterator());
                result = finder.getDecl();
                if (result == null) continue;
                break;
            }
        }
        return result;
    }

    private MethodNameDeclaration createBuiltInMethodDeclaration(String methodName, int parameterCount) {
        ASTMethodDeclaration methodDeclaration = new ASTMethodDeclaration(21);
        methodDeclaration.setPublic(true);
        methodDeclaration.setScope((Scope)this);
        ASTMethodDeclarator methodDeclarator = new ASTMethodDeclarator(22);
        methodDeclarator.setImage(methodName);
        methodDeclarator.setScope((Scope)this);
        ASTFormalParameters formalParameters = new ASTFormalParameters(23);
        formalParameters.setScope((Scope)this);
        methodDeclaration.jjtAddChild((Node)methodDeclarator, 0);
        methodDeclarator.jjtSetParent(methodDeclaration);
        methodDeclarator.jjtAddChild((Node)formalParameters, 0);
        formalParameters.jjtSetParent((Node)methodDeclarator);
        for (int i = 0; i < parameterCount; ++i) {
            ASTFormalParameter formalParameter = new ASTFormalParameter(24);
            formalParameters.jjtAddChild(formalParameter, i);
            formalParameter.jjtSetParent((Node)formalParameters);
            ASTType type = new ASTType(28);
            formalParameter.jjtAddChild(type, 0);
            type.jjtSetParent(formalParameter);
            ASTVariableDeclaratorId variableDeclaratorId = new ASTVariableDeclaratorId(18);
            variableDeclaratorId.setImage("arg" + i);
            formalParameter.jjtAddChild(variableDeclaratorId, 1);
            variableDeclaratorId.jjtSetParent(formalParameter);
        }
        MethodNameDeclaration mnd = new MethodNameDeclaration(methodDeclarator);
        return mnd;
    }

    private List<TypedNameDeclaration> determineParameterTypes(MethodNameDeclaration mnd) {
        ArrayList<TypedNameDeclaration> parameterTypes = new ArrayList<TypedNameDeclaration>();
        List parameters = mnd.getMethodNameDeclaratorNode().findDescendantsOfType(ASTFormalParameter.class);
        for (ASTFormalParameter p : parameters) {
            String typeImage = p.getTypeNode().getTypeImage();
            typeImage = this.qualifyTypeName(typeImage);
            Node declaringNode = ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).getQualifiedTypeNames().get(typeImage);
            Class<?> resolvedType = ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).resolveType(typeImage);
            if (resolvedType == null) {
                resolvedType = this.resolveGenericType(p, typeImage);
            }
            parameterTypes.add(new SimpleTypedNameDeclaration(typeImage, resolvedType, this.determineSuper(declaringNode)));
        }
        return parameterTypes;
    }

    private String qualifyTypeName(String typeImage) {
        if (typeImage == null) {
            return null;
        }
        LinkedHashSet<String> qualifiedNames = new LinkedHashSet<String>();
        qualifiedNames.addAll(((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).getQualifiedTypeNames().keySet());
        qualifiedNames.addAll(((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).getExplicitImports());
        int nameLength = typeImage.length();
        for (String qualified : qualifiedNames) {
            int fullLength = qualified.length();
            if (!qualified.endsWith(typeImage) || fullLength != nameLength && !qualified.substring(0, fullLength - nameLength).endsWith(".")) continue;
            return qualified;
        }
        return typeImage;
    }

    private List<TypedNameDeclaration> determineArgumentTypes(JavaNameOccurrence occurrence, List<TypedNameDeclaration> parameterTypes) {
        ArrayList<TypedNameDeclaration> argumentTypes = new ArrayList<TypedNameDeclaration>();
        Map<String, Node> qualifiedTypeNames = ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).getQualifiedTypeNames();
        ASTArgumentList arguments = null;
        Node nextSibling = null;
        nextSibling = occurrence.getLocation() instanceof ASTPrimarySuffix ? this.getNextSibling((Node)occurrence.getLocation()) : this.getNextSibling(occurrence.getLocation().jjtGetParent());
        if (nextSibling != null) {
            arguments = (ASTArgumentList)nextSibling.getFirstDescendantOfType(ASTArgumentList.class);
        }
        if (arguments != null) {
            for (int i = 0; i < arguments.jjtGetNumChildren(); ++i) {
                Class<?> typeBound;
                Node argument = arguments.jjtGetChild(i);
                Node child = null;
                boolean isMethodCall = false;
                if (argument.jjtGetNumChildren() > 0 && argument.jjtGetChild(0).jjtGetNumChildren() > 0 && argument.jjtGetChild(0).jjtGetChild(0).jjtGetNumChildren() > 0) {
                    child = argument.jjtGetChild(0).jjtGetChild(0).jjtGetChild(0);
                    isMethodCall = argument.jjtGetChild(0).jjtGetNumChildren() > 1;
                }
                TypedNameDeclaration type = null;
                if (child instanceof ASTName && !isMethodCall) {
                    Scope s;
                    ASTName name = (ASTName)child;
                    for (s = name.getScope(); s != null && !s.contains((NameOccurrence)new JavaNameOccurrence(name, name.getImage())); s = s.getParent()) {
                    }
                    if (s != null) {
                        Map vars = s.getDeclarations(VariableNameDeclaration.class);
                        for (VariableNameDeclaration d : vars.keySet()) {
                            if (!d.getImage().equals(name.getImage()) || d.getTypeImage() == null) continue;
                            String typeName = d.getTypeImage();
                            typeName = this.qualifyTypeName(typeName);
                            Node declaringNode = qualifiedTypeNames.get(typeName);
                            type = new SimpleTypedNameDeclaration(typeName, ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).resolveType(typeName), this.determineSuper(declaringNode));
                            break;
                        }
                    }
                } else if (child instanceof ASTLiteral) {
                    ASTLiteral literal = (ASTLiteral)child;
                    if (literal.isCharLiteral()) {
                        type = new SimpleTypedNameDeclaration("char", literal.getType());
                    } else if (literal.isStringLiteral()) {
                        type = new SimpleTypedNameDeclaration("String", literal.getType());
                    } else if (literal.isFloatLiteral()) {
                        type = new SimpleTypedNameDeclaration("float", literal.getType());
                    } else if (literal.isDoubleLiteral()) {
                        type = new SimpleTypedNameDeclaration("double", literal.getType());
                    } else if (literal.isIntLiteral()) {
                        type = new SimpleTypedNameDeclaration("int", literal.getType());
                    } else if (literal.isLongLiteral()) {
                        type = new SimpleTypedNameDeclaration("long", literal.getType());
                    } else if (literal.jjtGetNumChildren() == 1 && literal.jjtGetChild(0) instanceof ASTBooleanLiteral) {
                        type = new SimpleTypedNameDeclaration("boolean", Boolean.TYPE);
                    }
                } else if (child instanceof ASTAllocationExpression && child.jjtGetChild(0) instanceof ASTClassOrInterfaceType) {
                    ASTClassOrInterfaceType classInterface = (ASTClassOrInterfaceType)child.jjtGetChild(0);
                    type = this.convertToSimpleType(classInterface);
                }
                if (type == null && !parameterTypes.isEmpty()) {
                    type = parameterTypes.size() > i ? parameterTypes.get(i) : parameterTypes.get(parameterTypes.size() - 1);
                }
                if (type != null && type.getType() == null && (typeBound = this.resolveGenericType(argument, type.getTypeImage())) != null) {
                    type = new SimpleTypedNameDeclaration(type.getTypeImage(), typeBound);
                }
                argumentTypes.add(type);
            }
        }
        return argumentTypes;
    }

    private SimpleTypedNameDeclaration determineSuper(Node declaringNode) {
        SimpleTypedNameDeclaration result = null;
        if (declaringNode instanceof ASTClassOrInterfaceDeclaration) {
            ASTExtendsList extendsList;
            ASTClassOrInterfaceDeclaration classDeclaration = (ASTClassOrInterfaceDeclaration)declaringNode;
            ASTImplementsList implementsList = (ASTImplementsList)classDeclaration.getFirstChildOfType(ASTImplementsList.class);
            if (implementsList != null) {
                SimpleTypedNameDeclaration type;
                List types = implementsList.findChildrenOfType(ASTClassOrInterfaceType.class);
                result = type = this.convertToSimpleType(types);
            }
            if ((extendsList = (ASTExtendsList)classDeclaration.getFirstChildOfType(ASTExtendsList.class)) != null) {
                List types = extendsList.findChildrenOfType(ASTClassOrInterfaceType.class);
                SimpleTypedNameDeclaration type = this.convertToSimpleType(types);
                if (result == null) {
                    result = type;
                } else {
                    result.addNext(type);
                }
            }
        }
        return result;
    }

    private SimpleTypedNameDeclaration convertToSimpleType(List<ASTClassOrInterfaceType> types) {
        SimpleTypedNameDeclaration result = null;
        for (ASTClassOrInterfaceType t : types) {
            SimpleTypedNameDeclaration type = this.convertToSimpleType(t);
            if (result == null) {
                result = type;
                continue;
            }
            result.addNext(type);
        }
        return result;
    }

    private SimpleTypedNameDeclaration convertToSimpleType(ASTClassOrInterfaceType t) {
        String typeImage = t.getImage();
        typeImage = this.qualifyTypeName(typeImage);
        Node declaringNode = ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).getQualifiedTypeNames().get(typeImage);
        return new SimpleTypedNameDeclaration(typeImage, ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).resolveType(typeImage), this.determineSuper(declaringNode));
    }

    private Class<?> resolveGenericType(Node argument, String typeImage) {
        ASTClassOrInterfaceDeclaration enclosingClassOrEnum;
        ArrayList<ASTTypeParameter> types = new ArrayList<ASTTypeParameter>();
        ASTClassOrInterfaceBodyDeclaration firstParentOfType = (ASTClassOrInterfaceBodyDeclaration)argument.getFirstParentOfType(ASTClassOrInterfaceBodyDeclaration.class);
        if (firstParentOfType != null) {
            types.addAll(firstParentOfType.findDescendantsOfType(ASTTypeParameter.class));
        }
        if ((enclosingClassOrEnum = (ASTClassOrInterfaceDeclaration)argument.getFirstParentOfType(ASTClassOrInterfaceDeclaration.class)) == null) {
            argument.getFirstParentOfType(ASTEnumDeclaration.class);
        }
        ASTTypeParameters classLevelTypeParameters = null;
        if (enclosingClassOrEnum != null) {
            classLevelTypeParameters = (ASTTypeParameters)enclosingClassOrEnum.getFirstChildOfType(ASTTypeParameters.class);
        }
        if (classLevelTypeParameters != null) {
            types.addAll(classLevelTypeParameters.findDescendantsOfType(ASTTypeParameter.class));
        }
        return this.resolveGenericType(typeImage, types);
    }

    private Class<?> resolveGenericType(String typeImage, List<ASTTypeParameter> types) {
        for (ASTTypeParameter type : types) {
            if (!typeImage.equals(type.getImage())) continue;
            ASTClassOrInterfaceType bound = (ASTClassOrInterfaceType)type.getFirstDescendantOfType(ASTClassOrInterfaceType.class);
            if (bound != null) {
                if (bound.getType() != null) {
                    return bound.getType();
                }
                return ((SourceFileScope)this.getEnclosingScope(SourceFileScope.class)).resolveType(bound.getImage());
            }
            return Object.class;
        }
        return null;
    }

    private Node getNextSibling(Node current) {
        Node nextSibling = null;
        for (int i = 0; i < current.jjtGetParent().jjtGetNumChildren() - 1; ++i) {
            if (current.jjtGetParent().jjtGetChild(i) != current) continue;
            nextSibling = current.jjtGetParent().jjtGetChild(i + 1);
            break;
        }
        return nextSibling;
    }

    public String toString() {
        Map<VariableNameDeclaration, List<NameOccurrence>> variableDeclarations;
        Map<MethodNameDeclaration, List<NameOccurrence>> methodDeclarations;
        StringBuilder res = new StringBuilder("ClassScope (").append(this.className).append("): ");
        Map<ClassNameDeclaration, List<NameOccurrence>> classDeclarations = this.getClassDeclarations();
        if (classDeclarations.isEmpty()) {
            res.append("Inner Classes ").append(this.glomNames(classDeclarations.keySet())).append("; ");
        }
        if (!(methodDeclarations = this.getMethodDeclarations()).isEmpty()) {
            for (MethodNameDeclaration mnd : methodDeclarations.keySet()) {
                res.append(mnd.toString());
                int usages = methodDeclarations.get((Object)mnd).size();
                res.append("(begins at line ").append(mnd.getNode().getBeginLine()).append(", ").append(usages).append(" usages)");
                res.append(", ");
            }
        }
        if (!(variableDeclarations = this.getVariableDeclarations()).isEmpty()) {
            res.append("Variables ").append(this.glomNames(variableDeclarations.keySet()));
        }
        return res.toString();
    }

    private String clipClassName(String s) {
        return s.substring(s.indexOf(46) + 1);
    }
}

