/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.naming;

import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.rule.properties.BooleanProperty;

public class MethodNamingConventionsRule
extends AbstractJavaRule {
    private boolean checkNativeMethods;
    private static final BooleanProperty CHECK_NATIVE_METHODS_DESCRIPTOR = new BooleanProperty("checkNativeMethods", "Check native methods", Boolean.valueOf(true), 1.0f);

    public MethodNamingConventionsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)CHECK_NATIVE_METHODS_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.checkNativeMethods = (Boolean)this.getProperty((PropertyDescriptor)CHECK_NATIVE_METHODS_DESCRIPTOR);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclarator node, Object data) {
        if (!this.checkNativeMethods && ((ASTMethodDeclaration)node.getFirstParentOfType(ASTMethodDeclaration.class)).isNative()) {
            return data;
        }
        String methodName = node.getImage();
        if (Character.isUpperCase(methodName.charAt(0))) {
            this.addViolationWithMessage(data, (Node)node, "Method names should not start with capital letters");
        }
        if (methodName.indexOf(95) >= 0) {
            this.addViolationWithMessage(data, (Node)node, "Method names should not contain underscores");
        }
        return data;
    }
}

