/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.coupling;

import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTReferenceType;
import net.sourceforge.pmd.lang.java.ast.ASTResultType;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.symboltable.ClassScope;
import net.sourceforge.pmd.lang.rule.properties.IntegerProperty;

public class CouplingBetweenObjectsRule
extends AbstractJavaRule {
    private int couplingCount;
    private Set<String> typesFoundSoFar;
    private static final IntegerProperty THRESHOLD_DESCRIPTOR = new IntegerProperty("threshold", "Unique type reporting threshold", Integer.valueOf(2), Integer.valueOf(100), Integer.valueOf(20), 1.0f);

    public CouplingBetweenObjectsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)THRESHOLD_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit cu, Object data) {
        this.typesFoundSoFar = new HashSet<String>();
        this.couplingCount = 0;
        Object returnObj = cu.childrenAccept(this, data);
        if (this.couplingCount > (Integer)this.getProperty((PropertyDescriptor)THRESHOLD_DESCRIPTOR)) {
            this.addViolation(data, cu, "A value of " + this.couplingCount + " may denote a high amount of coupling within the class");
        }
        return returnObj;
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTResultType node, Object data) {
        for (int x = 0; x < node.jjtGetNumChildren(); ++x) {
            Node classOrIntType;
            Node reftypeNode;
            Node tNode = node.jjtGetChild(x);
            if (!(tNode instanceof ASTType) || !((reftypeNode = tNode.jjtGetChild(0)) instanceof ASTReferenceType) || !((classOrIntType = reftypeNode.jjtGetChild(0)) instanceof ASTClassOrInterfaceType)) continue;
            Node nameNode = classOrIntType;
            this.checkVariableType(nameNode, nameNode.getImage());
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTLocalVariableDeclaration node, Object data) {
        this.handleASTTypeChildren(node);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFormalParameter node, Object data) {
        this.handleASTTypeChildren(node);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTFieldDeclaration node, Object data) {
        for (int x = 0; x < node.jjtGetNumChildren(); ++x) {
            Node firstStmt = node.jjtGetChild(x);
            if (!(firstStmt instanceof ASTType)) continue;
            ASTType tp = (ASTType)firstStmt;
            Node nd = tp.jjtGetChild(0);
            this.checkVariableType(nd, nd.getImage());
        }
        return super.visit(node, data);
    }

    private void handleASTTypeChildren(Node node) {
        for (int x = 0; x < node.jjtGetNumChildren(); ++x) {
            Node sNode = node.jjtGetChild(x);
            if (!(sNode instanceof ASTType)) continue;
            Node nameNode = sNode.jjtGetChild(0);
            this.checkVariableType(nameNode, nameNode.getImage());
        }
    }

    private void checkVariableType(Node nameNode, String variableType) {
        if (nameNode.getParentsOfType(ASTClassOrInterfaceDeclaration.class).isEmpty()) {
            return;
        }
        ClassScope clzScope = (ClassScope)((JavaNode)nameNode).getScope().getEnclosingScope(ClassScope.class);
        if (!(clzScope.getClassName().equals(variableType) || this.filterTypes(variableType) || this.typesFoundSoFar.contains(variableType))) {
            ++this.couplingCount;
            this.typesFoundSoFar.add(variableType);
        }
    }

    private boolean filterTypes(String variableType) {
        return variableType != null && (variableType.startsWith("java.lang.") || variableType.equals("String") || this.filterPrimitivesAndWrappers(variableType));
    }

    private boolean filterPrimitivesAndWrappers(String variableType) {
        return variableType.equals("int") || variableType.equals("Integer") || variableType.equals("char") || variableType.equals("Character") || variableType.equalsIgnoreCase("double") || variableType.equalsIgnoreCase("long") || variableType.equalsIgnoreCase("short") || variableType.equalsIgnoreCase("float") || variableType.equalsIgnoreCase("byte") || variableType.equalsIgnoreCase("boolean");
    }
}

