/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.ant.ReportException;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.CPDReportRenderer;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.CpdAnalysis;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.XMLOldRenderer;
import net.sourceforge.pmd.cpd.XMLRenderer;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

public class CPDTask
extends Task {
    private static final String TEXT_FORMAT = "text";
    private static final String XML_FORMAT = "xml";
    @Deprecated
    private static final String XMLOLD_FORMAT = "xmlold";
    private static final String CSV_FORMAT = "csv";
    private String format = "text";
    private String language = "java";
    private int minimumTokenCount;
    private boolean ignoreLiterals;
    private boolean ignoreIdentifiers;
    private boolean ignoreAnnotations;
    private boolean ignoreUsings;
    @Deprecated
    private boolean skipLexicalErrors;
    private boolean skipDuplicateFiles;
    private boolean skipBlocks = true;
    private String skipBlocksPattern;
    private File outputFile;
    private String encoding = System.getProperty("file.encoding");
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private boolean failOnError = true;

    public void execute() throws BuildException {
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CPDTask.class.getClassLoader());
        try {
            this.validateFields();
            this.log("Starting run, minimumTokenCount is " + this.minimumTokenCount, 2);
            this.log("Tokenizing files", 2);
            CPDConfiguration config = new CPDConfiguration();
            config.setMinimumTileSize(this.minimumTokenCount);
            config.setOnlyRecognizeLanguage(config.getLanguageRegistry().getLanguageById(this.language));
            config.setSourceEncoding(Charset.forName(this.encoding));
            config.setSkipDuplicates(this.skipDuplicateFiles);
            if (this.skipLexicalErrors) {
                this.log("skipLexicalErrors is deprecated since 7.3.0 and the property is ignored. Lexical errors are now skipped by default and the build is failed. Use failOnError=\"false\" to not fail the build.", 1);
            }
            config.setIgnoreAnnotations(this.ignoreAnnotations);
            config.setIgnoreLiterals(this.ignoreLiterals);
            config.setIgnoreIdentifiers(this.ignoreIdentifiers);
            config.setIgnoreUsings(this.ignoreUsings);
            if (this.skipBlocks) {
                config.setSkipBlocksPattern(this.skipBlocksPattern);
            }
            try (CpdAnalysis cpd = CpdAnalysis.create((CPDConfiguration)config);){
                this.addFiles(cpd);
                this.log("Starting to analyze code", 2);
                long start = System.currentTimeMillis();
                cpd.performAnalysis(this::report);
                long timeTaken = System.currentTimeMillis() - start;
                this.log("Done analyzing code; that took " + timeTaken + " milliseconds");
                int errors = config.getReporter().numErrors();
                if (errors > 0) {
                    String message = String.format("There were %d recovered errors during analysis.", errors);
                    if (this.failOnError) {
                        throw new BuildException(message + " Ignore these with failOnError=\"true\".");
                    }
                    this.log(message + " Not failing build, because failOnError=\"false\".", 1);
                }
            }
        }
        catch (IOException ioe) {
            this.log(ioe.toString(), 0);
            throw new BuildException("IOException during task execution", (Throwable)ioe);
        }
        catch (ReportException re) {
            this.log(re.toString(), 0);
            throw new BuildException("ReportException during task execution", (Throwable)re);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }

    private void report(CPDReport report) throws ReportException {
        if (report.getMatches().isEmpty()) {
            this.log("No duplicates over " + this.minimumTokenCount + " tokens found", 2);
        }
        this.log("Generating report", 2);
        CPDReportRenderer renderer = this.createRenderer();
        try {
            OutputStream os = this.outputFile == null ? System.out : (this.outputFile.isAbsolute() ? Files.newOutputStream(this.outputFile.toPath(), new OpenOption[0]) : Files.newOutputStream(new File(this.getProject().getBaseDir(), this.outputFile.toString()).toPath(), new OpenOption[0]));
            if (this.encoding == null) {
                this.encoding = System.getProperty("file.encoding");
            }
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, this.encoding));){
                renderer.render(report, (Writer)writer);
            }
        }
        catch (IOException ioe) {
            throw new ReportException(ioe);
        }
    }

    private void addFiles(CpdAnalysis cpd) throws IOException {
        for (FileSet fileSet : this.filesets) {
            String[] includedFiles;
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            for (String includedFile : includedFiles = directoryScanner.getIncludedFiles()) {
                Path file = directoryScanner.getBasedir().toPath().resolve(includedFile);
                cpd.files().addFile(file);
            }
        }
    }

    private CPDReportRenderer createRenderer() {
        if (TEXT_FORMAT.equals(this.format)) {
            return new SimpleRenderer();
        }
        if (CSV_FORMAT.equals(this.format)) {
            return new CSVRenderer();
        }
        if (XMLOLD_FORMAT.equals(this.format)) {
            return new XMLOldRenderer();
        }
        return new XMLRenderer();
    }

    private void validateFields() throws BuildException {
        if (this.minimumTokenCount == 0) {
            throw new BuildException("minimumTokenCount is required and must be greater than zero");
        }
        if (this.filesets.isEmpty()) {
            throw new BuildException("Must include at least one FileSet");
        }
        if (LanguageRegistry.CPD.getLanguageById(this.language) == null) {
            throw new BuildException("Language " + this.language + " is not supported. Available languages: " + LanguageRegistry.CPD.commaSeparatedList(Language::getId));
        }
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setMinimumTokenCount(int minimumTokenCount) {
        this.minimumTokenCount = minimumTokenCount;
    }

    public void setIgnoreLiterals(boolean value) {
        this.ignoreLiterals = value;
    }

    public void setIgnoreIdentifiers(boolean value) {
        this.ignoreIdentifiers = value;
    }

    public void setIgnoreAnnotations(boolean value) {
        this.ignoreAnnotations = value;
    }

    public void setIgnoreUsings(boolean value) {
        this.ignoreUsings = value;
    }

    @Deprecated
    public void setSkipLexicalErrors(boolean skipLexicalErrors) {
        this.skipLexicalErrors = skipLexicalErrors;
    }

    public void setSkipDuplicateFiles(boolean skipDuplicateFiles) {
        this.skipDuplicateFiles = skipDuplicateFiles;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setFormat(FormatAttribute formatAttribute) {
        this.format = formatAttribute.getValue();
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSkipBlocks(boolean skipBlocks) {
        this.skipBlocks = skipBlocks;
    }

    public void setSkipBlocksPattern(String skipBlocksPattern) {
        this.skipBlocksPattern = skipBlocksPattern;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public static class FormatAttribute
    extends EnumeratedAttribute {
        private static final String[] FORMATS = new String[]{"xml", "text", "csv", "xmlold"};

        public String[] getValues() {
            return FORMATS;
        }
    }
}

