/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant.internal;

import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.ant.Formatter;
import net.sourceforge.pmd.ant.InternalApiBridge;
import net.sourceforge.pmd.ant.PMDTask;
import net.sourceforge.pmd.ant.SourceLanguage;
import net.sourceforge.pmd.ant.internal.Slf4jSimpleConfigurationForAnt;
import net.sourceforge.pmd.internal.Slf4jSimpleConfiguration;
import net.sourceforge.pmd.internal.util.ClasspathClassLoader;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.rule.RulePriority;
import net.sourceforge.pmd.lang.rule.RuleSetLoader;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.GlobalAnalysisListener;
import net.sourceforge.pmd.reporting.ReportStats;
import net.sourceforge.pmd.reporting.ReportStatsListener;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class PMDTaskImpl {
    private Path classpath;
    private Path auxClasspath;
    private final List<Formatter> formatters = new ArrayList<Formatter>();
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private final PMDConfiguration configuration = new PMDConfiguration();
    private boolean failOnError;
    private boolean failOnRuleViolation;
    private int maxRuleViolations = 0;
    private String failuresPropertyName;
    private Project project;

    public PMDTaskImpl(PMDTask task) {
        this.configuration.addRelativizeRoots(PMDTaskImpl.getRelativizeRoots(task));
        if (task.getSuppressMarker() != null) {
            this.configuration.setSuppressMarker(task.getSuppressMarker());
        }
        this.failOnError = task.isFailOnError();
        this.failOnRuleViolation = task.isFailOnRuleViolation();
        this.maxRuleViolations = task.getMaxRuleViolations();
        if (this.maxRuleViolations > 0) {
            this.failOnRuleViolation = true;
        }
        if (task.getRulesetFiles() != null) {
            this.configuration.setRuleSets(Arrays.asList(task.getRulesetFiles().split(",")));
        }
        if (task.getEncoding() != null) {
            this.configuration.setSourceEncoding(Charset.forName(task.getEncoding()));
        }
        this.configuration.setThreads(task.getThreads());
        this.failuresPropertyName = task.getFailuresPropertyName();
        this.configuration.setMinimumPriority(RulePriority.valueOf((int)task.getMinimumPriority()));
        this.configuration.setAnalysisCacheLocation(task.getCacheLocation());
        this.configuration.setIgnoreIncrementalAnalysis(task.isNoCache());
        SourceLanguage version = task.getSourceLanguage();
        if (version != null) {
            LanguageVersion languageVersion;
            Language lang = LanguageRegistry.PMD.getLanguageById(version.getName());
            LanguageVersion languageVersion2 = languageVersion = lang == null ? null : lang.getVersion(version.getVersion());
            if (languageVersion == null) {
                throw new BuildException("The following language is not supported:" + version + '.');
            }
            this.configuration.setDefaultLanguageVersion(languageVersion);
        }
        this.classpath = task.getClasspath();
        this.auxClasspath = task.getAuxClasspath();
        this.filesets.addAll(task.getFilesets());
        this.formatters.addAll(task.getFormatters());
        this.project = task.getProject();
    }

    private static List<java.nio.file.Path> getRelativizeRoots(PMDTask pmdTask) {
        ArrayList<java.nio.file.Path> paths = new ArrayList<java.nio.file.Path>();
        for (Path path : pmdTask.getRelativizePathsWith()) {
            for (Resource resource : path) {
                paths.add(Paths.get(resource.toString(), new String[0]));
            }
        }
        return paths;
    }

    private void doTask() {
        ReportStats stats;
        this.setupClassLoader();
        if (this.configuration.getSuppressMarker() != null) {
            this.project.log("Setting suppress marker to be " + this.configuration.getSuppressMarker(), 3);
        }
        List<String> ruleSetPaths = this.expandRuleSetPaths(this.configuration.getRuleSetPaths());
        this.configuration.setRuleSets(Collections.emptyList());
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)this.configuration);){
            RuleSetLoader rulesetLoader = pmd.newRuleSetLoader().loadResourcesWith(this.setupResourceLoader());
            pmd.addRuleSets((Collection)net.sourceforge.pmd.lang.rule.InternalApiBridge.loadRuleSetsWithoutException((RuleSetLoader)rulesetLoader, ruleSetPaths));
            for (FileSet fileset : this.filesets) {
                DirectoryScanner ds = fileset.getDirectoryScanner(this.project);
                for (String srcFile : ds.getIncludedFiles()) {
                    pmd.files().addFile(ds.getBasedir().toPath().resolve(srcFile));
                }
            }
            ReportStatsListener reportStatsListener = new ReportStatsListener();
            pmd.addListener(this.getListener(reportStatsListener));
            pmd.performAnalysis();
            stats = (ReportStats)reportStatsListener.getResult();
            if (this.failOnError && pmd.getReporter().numErrors() > 0) {
                throw new BuildException("Some errors occurred while running PMD");
            }
        }
        int problemCount = stats.getNumViolations();
        this.project.log(problemCount + " problems found", 3);
        if (this.failuresPropertyName != null && problemCount > 0) {
            this.project.setProperty(this.failuresPropertyName, String.valueOf(problemCount));
            this.project.log("Setting property " + this.failuresPropertyName + " to " + problemCount, 3);
        }
        if (this.failOnRuleViolation && problemCount > this.maxRuleViolations) {
            throw new BuildException("Stopping build since PMD found " + problemCount + " rule violations in the code");
        }
    }

    private List<String> expandRuleSetPaths(List<String> ruleSetPaths) {
        ArrayList<String> paths = new ArrayList<String>(ruleSetPaths);
        for (int i = 0; i < paths.size(); ++i) {
            paths.set(i, this.project.replaceProperties((String)paths.get(i)));
        }
        return paths;
    }

    private @NonNull GlobalAnalysisListener getListener(ReportStatsListener reportSizeListener) {
        ArrayList<Object> renderers = new ArrayList<Object>(this.formatters.size() + 1);
        try {
            renderers.add(this.makeLogListener());
            renderers.add(reportSizeListener);
            for (Formatter formatter : this.formatters) {
                this.project.log("Sending a report to " + formatter, 3);
                renderers.add(InternalApiBridge.newListener(formatter, this.project));
            }
            return GlobalAnalysisListener.tee(renderers);
        }
        catch (Exception e) {
            Exception e2 = IOUtil.closeAll(renderers);
            if (e2 != null) {
                e.addSuppressed(e2);
            }
            throw new BuildException("Exception while initializing renderers", (Throwable)e);
        }
    }

    private GlobalAnalysisListener makeLogListener() {
        return new GlobalAnalysisListener(){

            public FileAnalysisListener startFileAnalysis(TextFile dataSource) {
                String name = dataSource.getFileId().getUriString();
                PMDTaskImpl.this.project.log("Processing file " + name, 3);
                return FileAnalysisListener.noop();
            }

            public void close() {
            }
        };
    }

    private ClassLoader setupResourceLoader() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        this.classpath.add(new Path(null, this.project.getBaseDir().toString()));
        this.project.log("Using the AntClassLoader: " + this.classpath, 3);
        boolean parentFirst = true;
        return new AntClassLoader(Thread.currentThread().getContextClassLoader(), this.project, this.classpath, true);
    }

    private void setupClassLoader() {
        try {
            if (this.auxClasspath != null) {
                this.project.log("Using auxclasspath: " + this.auxClasspath, 3);
                this.configuration.prependAuxClasspath(this.auxClasspath.toString());
            }
        }
        catch (IllegalArgumentException ioe) {
            throw new BuildException(ioe.getMessage(), (Throwable)ioe);
        }
    }

    public void execute() throws BuildException {
        Level level = Slf4jSimpleConfigurationForAnt.reconfigureLoggingForAnt(this.project);
        Slf4jSimpleConfiguration.installJulBridge();
        Logger log = LoggerFactory.getLogger(PMDTaskImpl.class);
        log.info("Logging is at {}", (Object)level);
        try {
            this.doTask();
        }
        finally {
            if (this.configuration.getClassLoader() instanceof ClasspathClassLoader) {
                IOUtil.tryCloseClassLoader((ClassLoader)this.configuration.getClassLoader());
            }
        }
    }
}

