/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.modularity.locality;

import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.modularity.locality.LocalityClass;
import org.semanticweb.owlapi.modularity.locality.LocalityEvaluator;
import org.semanticweb.owlapi.modularity.locality.LocalityModuleExtractor;
import org.semanticweb.owlapi.modularity.locality.SemanticLocalityEvaluator;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public final class SemanticLocalityModuleExtractor
extends LocalityModuleExtractor {
    private final OWLReasonerFactory reasonerFactory;
    private final OWLOntologyManager ontologyManager;
    private SemanticLocalityEvaluator topEvaluator;
    private SemanticLocalityEvaluator botEvaluator;

    public SemanticLocalityModuleExtractor(LocalityClass localityClass, Stream<OWLAxiom> axiomBase, OWLOntologyManager ontologyManager, OWLReasonerFactory reasonerFactory) {
        super(localityClass, axiomBase);
        this.initEvaluators();
        this.reasonerFactory = reasonerFactory;
        this.ontologyManager = ontologyManager;
    }

    private void initEvaluators() {
        if (this.getLocalityClass() == LocalityClass.BOTTOM || this.getLocalityClass() == LocalityClass.STAR) {
            this.botEvaluator = new SemanticLocalityEvaluator(LocalityClass.BOTTOM, this.ontologyManager, this.reasonerFactory);
        }
        if (this.getLocalityClass() == LocalityClass.TOP || this.getLocalityClass() == LocalityClass.STAR) {
            this.topEvaluator = new SemanticLocalityEvaluator(LocalityClass.TOP, this.ontologyManager, this.reasonerFactory);
        }
    }

    public void dispose() {
        if (this.botEvaluator != null) {
            this.botEvaluator.dispose();
        }
        if (this.topEvaluator != null) {
            this.topEvaluator.dispose();
        }
    }

    @Override
    protected LocalityEvaluator bottomEvaluator() {
        return this.botEvaluator;
    }

    @Override
    protected LocalityEvaluator topEvaluator() {
        return this.topEvaluator;
    }
}

