/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation;

import com.clarkparsia.owlapi.explanation.TransactionAwareSingleExpGen;
import com.clarkparsia.owlapi.explanation.util.DefinitionTracker;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public abstract class SingleExplanationGeneratorImpl
implements TransactionAwareSingleExpGen {
    private boolean inTransaction;
    private final OWLOntologyManager owlOntologyManager;
    private final OWLOntology ontology;
    private final OWLReasoner reasoner;
    private final OWLReasonerFactory reasonerFactory;
    private final DefinitionTracker definitionTracker;

    public SingleExplanationGeneratorImpl(OWLOntology ontology, OWLReasonerFactory reasonerFactory, OWLReasoner reasoner) {
        this.ontology = (OWLOntology)OWLAPIPreconditions.checkNotNull((Object)ontology, (String)"ontology cannot be null");
        this.reasonerFactory = (OWLReasonerFactory)OWLAPIPreconditions.checkNotNull((Object)reasonerFactory, (String)"reasonerFactory cannot be null");
        this.reasoner = (OWLReasoner)OWLAPIPreconditions.checkNotNull((Object)reasoner, (String)"reasoner cannot be null");
        this.owlOntologyManager = ontology.getOWLOntologyManager();
        this.definitionTracker = new DefinitionTracker(ontology);
    }

    @Override
    public OWLOntologyManager getOntologyManager() {
        return this.owlOntologyManager;
    }

    @Override
    public OWLReasoner getReasoner() {
        return this.reasoner;
    }

    public DefinitionTracker getDefinitionTracker() {
        return this.definitionTracker;
    }

    @Override
    public OWLOntology getOntology() {
        return this.ontology;
    }

    @Override
    public OWLReasonerFactory getReasonerFactory() {
        return this.reasonerFactory;
    }

    protected boolean isFirstExplanation() {
        return !this.inTransaction;
    }

    @Override
    public void beginTransaction() {
        if (this.inTransaction) {
            throw new OWLRuntimeException("Already in transaction");
        }
        this.inTransaction = true;
    }

    @Override
    public void endTransaction() {
        if (!this.inTransaction) {
            throw new OWLRuntimeException("Cannot end transaction");
        }
        this.inTransaction = false;
    }
}

