/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openrdf.OpenRDFUtil;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.rdf.RDFRendererBase;
import org.semanticweb.owlapi.rio.utils.RioUtils;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RioRenderer
extends RDFRendererBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(RioRenderer.class);
    private final RDFHandler writer;
    private final DefaultPrefixManager pm;
    private final Set<RDFResource> pending = new LinkedHashSet<RDFResource>();
    private final Set<RDFTriple> renderedStatements = new LinkedHashSet<RDFTriple>();
    private final Resource[] contexts;

    public RioRenderer(OWLOntology ontology, RDFHandler writer, OWLDocumentFormat format, Resource ... contexts) {
        super(ontology, format, ontology.getOWLOntologyManager().getOntologyWriterConfiguration());
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        this.contexts = contexts;
        this.writer = writer;
        this.pm = new DefaultPrefixManager();
        if (!ontology.isAnonymous()) {
            String ontologyIRIString;
            String defaultPrefix = ontologyIRIString = ((IRI)ontology.getOntologyID().getOntologyIRI().get()).toString();
            if (!ontologyIRIString.endsWith("/")) {
                defaultPrefix = ontologyIRIString + '#';
            }
            this.pm.setDefaultPrefix(defaultPrefix);
        }
        if (format instanceof PrefixDocumentFormat) {
            PrefixDocumentFormat prefixFormat = (PrefixDocumentFormat)format;
            this.pm.copyPrefixesFrom((PrefixManager)prefixFormat);
            this.pm.setPrefixComparator(prefixFormat.getPrefixComparator());
        }
    }

    protected void beginDocument() {
        this.pending.clear();
        this.renderedStatements.clear();
        try {
            this.writer.startRDF();
        }
        catch (RDFHandlerException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
        this.writeNamespaces();
    }

    protected void endDocument() {
        this.writeComment(VersionInfo.getVersionInfo().getGeneratedByMessage());
        try {
            this.writer.endRDF();
        }
        catch (RDFHandlerException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("pendingNodes={}", (Object)this.pending.size());
            LOGGER.trace("renderedStatements={}", (Object)this.renderedStatements.size());
        }
        this.pending.clear();
        this.renderedStatements.clear();
    }

    protected void endObject() {
        this.writeComment("");
    }

    protected void writeAnnotationPropertyComment(OWLAnnotationProperty prop) {
        this.writeComment(prop.getIRI().toString());
    }

    protected void writeClassComment(OWLClass cls) {
        this.writeComment(cls.getIRI().toString());
    }

    protected void writeDataPropertyComment(OWLDataProperty prop) {
        this.writeComment(prop.getIRI().toString());
    }

    protected void writeDatatypeComment(OWLDatatype datatype) {
        this.writeComment(datatype.getIRI().toString());
    }

    protected void writeIndividualComments(OWLNamedIndividual ind) {
        this.writeComment(ind.getIRI().toString());
    }

    protected void writeObjectPropertyComment(OWLObjectProperty prop) {
        this.writeComment(prop.getIRI().toString());
    }

    protected void writeBanner(String name) {
        this.writeComment("");
        this.writeComment("");
        this.writeComment("#################################################################");
        this.writeComment("#");
        this.writeComment("#    " + name);
        this.writeComment("#");
        this.writeComment("#################################################################");
        this.writeComment("");
        this.writeComment("");
    }

    private void writeComment(String comment) {
        try {
            this.writer.handleComment(comment);
        }
        catch (RDFHandlerException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    private void writeNamespaces() {
        for (String prefixName : this.pm.getPrefixName2PrefixMap().keySet()) {
            String prefix = this.pm.getPrefix(prefixName);
            if (prefixName.endsWith(":")) {
                prefixName = prefixName.substring(0, prefixName.length() - 1);
            }
            try {
                this.writer.handleNamespace(prefixName, prefix);
            }
            catch (RDFHandlerException e) {
                throw new OWLRuntimeException((Throwable)e);
            }
        }
    }

    public void render(RDFResource node) {
        if (this.pending.contains(node)) {
            return;
        }
        this.pending.add(node);
        Collection triples = this.getRDFGraph().getTriplesForSubject((RDFNode)node);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("triples.size()={}", (Object)triples.size());
            if (!triples.isEmpty()) {
                LOGGER.trace("triples={}", (Object)triples);
            }
        }
        for (RDFTriple triple : triples) {
            RDFTriple tripleToRender = this.remapNodesIfNecessary(node, triple);
            try {
                if (!this.renderedStatements.contains(tripleToRender)) {
                    this.renderedStatements.add(tripleToRender);
                    for (Statement statement : RioUtils.tripleAsStatements(tripleToRender, this.contexts)) {
                        this.writer.handleStatement(statement);
                        if (!(tripleToRender.getObject() instanceof RDFResource)) continue;
                        this.render((RDFResource)tripleToRender.getObject());
                    }
                    continue;
                }
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace("not printing duplicate statement, or recursing on its object: {}", (Object)tripleToRender);
            }
            catch (RDFHandlerException e) {
                throw new OWLRuntimeException((Throwable)e);
            }
        }
        this.pending.remove(node);
    }
}

