/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.owlxml.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.semanticweb.owlapi.formats.OWLXMLDocumentFormat;
import org.semanticweb.owlapi.formats.OWLXMLDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLPH;
import org.semanticweb.owlapi.owlxml.parser.OWLXMLParserException;
import org.semanticweb.owlapi.util.SAXParsers;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OWLXMLParser
extends AbstractOWLParser {
    public OWLDocumentFormatFactory getSupportedFormat() {
        return new OWLXMLDocumentFormatFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OWLDocumentFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) {
        InputSource isrc = null;
        try {
            isrc = this.getInputSource(documentSource, configuration);
            OWLXMLPH handler = new OWLXMLPH(ontology, configuration);
            SAXParsers.initParserWithOWLAPIStandards(null, (String)configuration.getEntityExpansionLimit()).parse(isrc, (DefaultHandler)handler);
            if (!handler.atLeastOneTagFound()) {
                throw new OWLXMLParserException(handler, "No known tags in the input: is the file an OWL/XML ontology?");
            }
            OWLXMLDocumentFormat format = new OWLXMLDocumentFormat();
            format.copyPrefixesFrom(handler.getPrefixName2PrefixMap());
            String base = handler.getBase().toString();
            if (base != null && format.getDefaultPrefix() == null) {
                format.setDefaultPrefix(XMLUtils.iriWithTerminatingHash((String)base));
            }
            OWLXMLDocumentFormat oWLXMLDocumentFormat = format;
            return oWLXMLDocumentFormat;
        }
        catch (IOException | IllegalStateException | OWLOntologyInputSourceException | SAXException e) {
            throw new OWLParserException(e);
        }
        finally {
            block38: {
                if (isrc != null) {
                    try (InputStream byteStream = isrc.getByteStream();){
                        Reader characterStream = isrc.getCharacterStream();
                        Throwable throwable = null;
                        if (characterStream == null) break block38;
                        if (throwable != null) {
                            try {
                                characterStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            characterStream.close();
                        }
                    }
                    catch (IOException e) {
                        throw new OWLParserException((Throwable)e);
                    }
                }
            }
        }
    }
}

