/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.renderer;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.parsers.SAXParser;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyWriterConfiguration;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.parameters.ConfigurationOptions;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.IllegalElementNameException;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.XMLWriter;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.XMLWriterNamespaceManager;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.SAXParsers;
import org.semanticweb.owlapi.util.StringLengthComparator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLWriterImpl
implements XMLWriter {
    private final Deque<XMLElement> elementStack = new LinkedList<XMLElement>();
    protected final PrintWriter writer;
    private String encoding = "";
    private final String xmlBase;
    private final XMLWriterNamespaceManager xmlWriterNamespaceManager;
    private Map<String, String> entities;
    private static final int TEXT_CONTENT_WRAP_LIMIT = Integer.MAX_VALUE;
    private boolean preambleWritten;
    private static final String PERCENT_ENTITY = "&#37;";
    protected final OWLOntologyWriterConfiguration xmlPreferences;

    public XMLWriterImpl(PrintWriter writer, XMLWriterNamespaceManager xmlWriterNamespaceManager, String xmlBase, OWLOntologyWriterConfiguration preferences) {
        this.writer = (PrintWriter)OWLAPIPreconditions.checkNotNull((Object)writer, (String)"writer cannot be null");
        this.xmlWriterNamespaceManager = (XMLWriterNamespaceManager)OWLAPIPreconditions.checkNotNull((Object)xmlWriterNamespaceManager, (String)"xmlWriterNamespaceManager cannot be null");
        this.xmlBase = (String)OWLAPIPreconditions.checkNotNull((Object)xmlBase, (String)"xmlBase cannot be null");
        this.xmlPreferences = (OWLOntologyWriterConfiguration)OWLAPIPreconditions.checkNotNull((Object)preferences, (String)"preferences cannot be null");
        this.setupEntities();
    }

    private void setupEntities() {
        ArrayList namespaces = Lists.newArrayList(this.xmlWriterNamespaceManager.getNamespaces());
        Collections.sort(namespaces, new StringLengthComparator());
        this.entities = new LinkedHashMap<String, String>();
        for (String curNamespace : namespaces) {
            String curPrefix = this.getCurrentPrefix(curNamespace);
            if (curPrefix == null || curPrefix.isEmpty()) continue;
            this.entities.put(curNamespace, '&' + curPrefix + ';');
        }
    }

    @Nullable
    protected String getCurrentPrefix(String curNamespace) {
        if (this.xmlWriterNamespaceManager.getDefaultNamespace().equals(curNamespace)) {
            return this.xmlWriterNamespaceManager.getDefaultPrefix();
        }
        return this.xmlWriterNamespaceManager.getPrefixForNamespace(curNamespace);
    }

    protected String swapForEntity(String value) {
        for (Map.Entry<String, String> e : this.entities.entrySet()) {
            String repVal;
            if (value.length() <= e.getKey().length() || (repVal = value.replace(e.getKey(), e.getValue())).length() >= value.length()) continue;
            return repVal;
        }
        return value;
    }

    public String getDefaultNamespace() {
        return this.xmlWriterNamespaceManager.getDefaultNamespace();
    }

    @Override
    public String getXMLBase() {
        return this.xmlBase;
    }

    @Override
    public XMLWriterNamespaceManager getNamespacePrefixes() {
        return this.xmlWriterNamespaceManager;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void setWrapAttributes(boolean b) {
        if (!this.elementStack.isEmpty()) {
            XMLElement element = this.elementStack.peek();
            element.setWrapAttributes(b);
        }
    }

    @Override
    public void writeStartElement(IRI name) {
        XMLElement topElement;
        String qName = this.xmlWriterNamespaceManager.getQName(name);
        if (!XMLUtils.isQName((CharSequence)qName)) {
            throw new IllegalElementNameException(name.toString());
        }
        XMLElement element = new XMLElement(qName, this.elementStack.size());
        if (!this.elementStack.isEmpty() && (topElement = this.elementStack.peek()) != null) {
            topElement.writeElementStart(false);
        }
        this.elementStack.push(element);
    }

    @Override
    public void writeEndElement() {
        if (!this.elementStack.isEmpty()) {
            XMLElement element = this.elementStack.pop();
            element.writeElementEnd();
        }
    }

    @Override
    public void writeAttribute(String attr, String val) {
        XMLElement element = this.elementStack.peek();
        String qName = this.xmlWriterNamespaceManager.getQName(attr);
        if (qName != null) {
            element.setAttribute(qName, val);
        }
    }

    @Override
    public void writeAttribute(IRI attr, String val) {
        XMLElement element = this.elementStack.peek();
        String qName = this.xmlWriterNamespaceManager.getQName(attr);
        element.setAttribute(qName, val);
    }

    @Override
    public void writeTextContent(String text) {
        XMLElement element = this.elementStack.peek();
        element.setText(text);
    }

    @Override
    public void writeComment(String commentText) {
        XMLElement topElement;
        XMLElement element = new XMLElement(null, this.elementStack.size());
        element.setText("<!-- " + commentText.replace("--", "&#45;&#45;") + " -->");
        if (!this.elementStack.isEmpty() && (topElement = this.elementStack.peek()) != null) {
            topElement.writeElementStart(false);
        }
        if (this.preambleWritten) {
            element.writeElementStart(true);
        } else {
            this.elementStack.push(element);
        }
    }

    private void writeEntities(IRI rootName) {
        String qName = this.xmlWriterNamespaceManager.getQName(rootName);
        if (!XMLUtils.isQName((CharSequence)qName)) {
            throw new OWLRuntimeException("Cannot create valid XML: qname for " + rootName + " is null");
        }
        this.writer.write("\n\n<!DOCTYPE " + qName + " [\n");
        for (Map.Entry<String, String> e : this.entities.entrySet()) {
            this.writer.write("    <!ENTITY ");
            this.writer.write(e.getValue().substring(1, e.getValue().length() - 1));
            this.writer.write(" \"");
            this.writer.write(XMLUtils.escapeXML((CharSequence)e.getKey()).replace("%", PERCENT_ENTITY));
            this.writer.write("\" >\n");
        }
        this.writer.write("]>\n\n\n");
    }

    @Override
    public void startDocument(IRI rootElement) {
        String encodingString = "";
        if (!this.encoding.isEmpty()) {
            encodingString = " encoding=\"" + this.encoding + '\"';
        }
        this.writer.write("<?xml version=\"1.0\"" + encodingString + "?>\n");
        if (this.xmlPreferences.isUseNamespaceEntities()) {
            this.writeEntities(rootElement);
        }
        this.preambleWritten = true;
        while (!this.elementStack.isEmpty()) {
            this.elementStack.pop().writeElementStart(true);
        }
        this.writeStartElement(rootElement);
        this.setWrapAttributes(true);
        this.writeAttribute("xmlns", this.xmlWriterNamespaceManager.getDefaultNamespace());
        if (!this.xmlBase.isEmpty()) {
            this.writeAttribute("xml:base", this.xmlBase);
        }
        for (String curPrefix : this.xmlWriterNamespaceManager.getPrefixes()) {
            if (curPrefix.isEmpty()) continue;
            this.writeAttribute("xmlns:" + curPrefix, (String)OWLAPIPreconditions.verifyNotNull((Object)this.xmlWriterNamespaceManager.getNamespaceForPrefix(curPrefix)));
        }
    }

    @Override
    public void endDocument() {
        while (!this.elementStack.isEmpty()) {
            this.writeEndElement();
        }
        this.writer.flush();
    }

    public class XMLElement {
        @Nullable
        private final String name;
        private final Map<String, String> attributes = new LinkedHashMap<String, String>();
        @Nullable
        protected String textContent = null;
        private boolean startWritten = false;
        private int indentation;
        private boolean wrapAttributes = false;

        public XMLElement(String name, int indentation) {
            this.name = name;
            this.indentation = indentation;
        }

        public void setWrapAttributes(boolean b) {
            this.wrapAttributes = b;
        }

        public void setAttribute(String attribute, String value) {
            this.attributes.put(attribute, value);
        }

        public void setText(String content) {
            this.textContent = content;
        }

        public void writeElementStart(boolean close) {
            if (!this.startWritten) {
                this.startWritten = true;
                this.insertIndentation();
                if (this.name != null) {
                    XMLWriterImpl.this.writer.write(60);
                    XMLWriterImpl.this.writer.write(this.name);
                    this.writeAttributes();
                    if (this.textContent != null) {
                        boolean wrap;
                        boolean bl = wrap = this.textContent.length() > Integer.MAX_VALUE;
                        if (wrap) {
                            this.writeNewLine();
                            ++this.indentation;
                            this.insertIndentation();
                        }
                        XMLWriterImpl.this.writer.write(62);
                        this.writeTextContent();
                        if (wrap) {
                            --this.indentation;
                        }
                    }
                    if (close) {
                        if (this.textContent != null) {
                            this.writeElementEnd();
                        } else {
                            XMLWriterImpl.this.writer.write("/>");
                            this.writeNewLine();
                        }
                    } else if (this.textContent == null) {
                        XMLWriterImpl.this.writer.write(62);
                        this.writeNewLine();
                    }
                } else if (this.textContent != null) {
                    XMLWriterImpl.this.writer.write("\n\n\n");
                    for (String token : Splitter.on((char)'\n').split((CharSequence)OWLAPIPreconditions.verifyNotNull((Object)this.textContent))) {
                        if (!"\n".equals(token)) {
                            this.insertIndentation();
                        }
                        XMLWriterImpl.this.writer.write(token);
                        XMLWriterImpl.this.writer.write("\n");
                    }
                    XMLWriterImpl.this.writer.write("\n\n");
                }
            }
        }

        public void writeElementEnd() {
            if (this.name != null) {
                if (!this.startWritten) {
                    this.writeElementStart(true);
                } else {
                    if (this.textContent == null) {
                        this.insertIndentation();
                    }
                    XMLWriterImpl.this.writer.write("</");
                    XMLWriterImpl.this.writer.write(this.name);
                    XMLWriterImpl.this.writer.write(">");
                    this.writeNewLine();
                }
            }
        }

        private void writeAttribute(String attr, String val) {
            XMLWriterImpl.this.writer.write(attr);
            XMLWriterImpl.this.writer.write(61);
            XMLWriterImpl.this.writer.write(34);
            if (XMLWriterImpl.this.xmlPreferences.isUseNamespaceEntities()) {
                XMLWriterImpl.this.writer.write(XMLWriterImpl.this.swapForEntity(XMLUtils.escapeXML((CharSequence)val)));
            } else {
                XMLWriterImpl.this.writer.write(XMLUtils.escapeXML((CharSequence)val));
            }
            XMLWriterImpl.this.writer.write(34);
        }

        private void writeAttributes() {
            Iterator<String> it = this.attributes.keySet().iterator();
            while (it.hasNext()) {
                String attr = it.next();
                String val = this.attributes.get(attr);
                XMLWriterImpl.this.writer.write(32);
                this.writeAttribute(attr, val);
                if (!it.hasNext() || !this.wrapAttributes) continue;
                XMLWriterImpl.this.writer.write("\n");
                ++this.indentation;
                this.insertIndentation();
                --this.indentation;
            }
        }

        private void writeTextContent() {
            if (this.textContent != null) {
                if (this.isRDFXMLLiteral()) {
                    this.checkProperXMLLiteral((String)OWLAPIPreconditions.verifyNotNull((Object)this.textContent));
                    XMLWriterImpl.this.writer.write(this.textContent);
                } else {
                    XMLWriterImpl.this.writer.write(XMLUtils.escapeXML((CharSequence)((CharSequence)OWLAPIPreconditions.verifyNotNull((Object)this.textContent))));
                }
            }
        }

        private boolean isRDFXMLLiteral() {
            return "http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral".equals(this.attributes.get("rdf:datatype")) || "Literal".equals(this.attributes.get("rdf:parseType"));
        }

        private void checkProperXMLLiteral(String text) {
            try {
                String expansions = (String)ConfigurationOptions.ENTITY_EXPANSION_LIMIT.getValue(String.class, Collections.emptyMap());
                SAXParser parser = SAXParsers.initParserWithOWLAPIStandards(null, (String)expansions);
                parser.parse(new InputSource(new StringReader(text)), new DefaultHandler());
            }
            catch (IOException | SAXException e) {
                throw new OWLRuntimeException("XML literal is not self contained: \"" + text + "\"", (Throwable)e);
            }
        }

        private void insertIndentation() {
            if (XMLWriterImpl.this.xmlPreferences.isIndenting()) {
                for (int i = 0; i < this.indentation * XMLWriterImpl.this.xmlPreferences.getIndentSize(); ++i) {
                    XMLWriterImpl.this.writer.write(32);
                }
            }
        }

        private void writeNewLine() {
            XMLWriterImpl.this.writer.write(10);
        }
    }
}

