/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.krss2.renderer;

import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.semanticweb.owlapi.krss2.renderer.KRSS2Vocabulary;
import org.semanticweb.owlapi.krss2.renderer.KRSSObjectRenderer;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.search.Filters;
import org.semanticweb.owlapi.search.Searcher;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class KRSS2OWLObjectRenderer
extends KRSSObjectRenderer {
    public KRSS2OWLObjectRenderer(OWLOntology ontology, Writer writer) {
        super(ontology, writer);
    }

    private void writeAttribute(KRSS2Vocabulary v) {
        this.writeSpace();
        this.writer.write(":");
        this.writer.write(v.toString());
    }

    @Override
    public void visit(OWLOntology ontology) {
        List classes1 = OWLAPIStreamUtils.asList((Stream)ontology.classesInSignature());
        classes1.remove(ontology.getOWLOntologyManager().getOWLDataFactory().getOWLThing());
        classes1.remove(ontology.getOWLOntologyManager().getOWLDataFactory().getOWLNothing());
        CollectionFactory.sortOptionally((List)classes1);
        for (OWLClass eachClass : classes1) {
            List classes;
            boolean primitive;
            boolean bl = primitive = !EntitySearcher.isDefined((OWLClass)eachClass, (OWLOntology)ontology);
            if (primitive) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_CONCEPT);
                this.write((OWLClassExpression)eachClass);
                this.writeSpace();
                this.flatten(OWLAPIStreamUtils.asList((Stream)Searcher.sup((Stream)ontology.subClassAxiomsForSubClass(eachClass), OWLClassExpression.class)));
                this.writeCloseBracket();
                this.writeln();
                classes = OWLAPIStreamUtils.asList((Stream)Searcher.equivalent((Stream)ontology.equivalentClassesAxioms(eachClass), OWLClassExpression.class));
                for (OWLClassExpression classExpression : classes) {
                    this.writeOpenBracket();
                    this.write((OWLClassExpression)eachClass);
                    this.write(KRSS2Vocabulary.EQUIVALENT);
                    this.writeSpace();
                    classExpression.accept((OWLObjectVisitor)this);
                    this.writeCloseBracket();
                    this.writeln();
                }
                continue;
            }
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.DEFINE_CONCEPT);
            this.write((OWLClassExpression)eachClass);
            classes = OWLAPIStreamUtils.asList((Stream)Searcher.equivalent((Stream)ontology.equivalentClassesAxioms(eachClass), OWLClassExpression.class));
            if (classes.isEmpty()) {
                this.writeCloseBracket();
                this.writeln();
                continue;
            }
            if (classes.size() == 1) {
                this.write((OWLClassExpression)classes.iterator().next());
                this.writeCloseBracket();
                this.writeln();
                continue;
            }
            Iterator iter = classes.iterator();
            this.write((OWLClassExpression)iter.next());
            this.writeCloseBracket();
            this.writeln();
            while (iter.hasNext()) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.EQUIVALENT);
                this.write((OWLClassExpression)eachClass);
                this.writeSpace();
                ((OWLClassExpression)iter.next()).accept((OWLObjectVisitor)this);
                this.writeCloseBracket();
                this.writeln();
            }
        }
        ontology.generalClassAxioms().forEach(a -> a.accept((OWLObjectVisitor)this));
        for (OWLObjectProperty property : OWLAPIStreamUtils.asList((Stream)ontology.objectPropertiesInSignature())) {
            Stream superProperties;
            Iterator it;
            List ranges;
            List domains;
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_ROLE);
            this.write((OWLPropertyExpression)property);
            if (EntitySearcher.isTransitive((OWLObjectPropertyExpression)property, (OWLOntology)ontology)) {
                this.writeAttribute(KRSS2Vocabulary.TRANSITIVE_ATTR);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if (EntitySearcher.isSymmetric((OWLObjectPropertyExpression)property, (OWLOntology)ontology)) {
                this.writeAttribute(KRSS2Vocabulary.SYMMETRIC_ATTR);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if (!(domains = OWLAPIStreamUtils.asList((Stream)Searcher.domain((Stream)ontology.objectPropertyDomainAxioms((OWLObjectPropertyExpression)property)))).isEmpty()) {
                this.writeAttribute(KRSS2Vocabulary.DOMAIN);
                this.flatten(domains);
            }
            if (!(ranges = OWLAPIStreamUtils.asList((Stream)Searcher.range((Stream)ontology.objectPropertyRangeAxioms((OWLObjectPropertyExpression)property)))).isEmpty()) {
                this.writeAttribute(KRSS2Vocabulary.RANGE_ATTR);
                this.flatten(ranges);
            }
            if ((it = (superProperties = Searcher.sup((Stream)ontology.axioms(Filters.subObjectPropertyWithSub, (Object)property, Imports.INCLUDED), OWLObjectPropertyExpression.class)).iterator()).hasNext()) {
                this.writeAttribute(KRSS2Vocabulary.PARENTS_ATTR);
                this.writeOpenBracket();
                while (it.hasNext()) {
                    this.write((OWLPropertyExpression)it.next());
                }
                this.writeCloseBracket();
            }
            this.writeCloseBracket();
        }
        this.writer.flush();
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.IMPLIES);
        this.write(axiom.getSubClass());
        this.write(axiom.getSuperClass());
        this.writeCloseBracket();
    }
}

