/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import org.semanticweb.owlapi.util.SmallSet;
import uk.ac.manchester.cs.owl.owlapi.InitVisitorFactory;
import uk.ac.manchester.cs.owl.owlapi.Internals;

public class MapPointer<K, V extends OWLAxiom> {
    private static final AtomicLong totalInUse = new AtomicLong(0L);
    private static final AtomicLong totalAllocated = new AtomicLong(0L);
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_INITIAL_CAPACITY = 5;
    @Nullable
    private final AxiomType<?> type;
    @Nullable
    private final OWLAxiomVisitorEx<?> visitor;
    private boolean initialized;
    protected final Internals i;
    @Nullable
    private SoftReference<Set<IRI>> iris;
    private int size = 0;
    private final THashMap<K, Collection<V>> map = new THashMap(17, 0.75f);
    private boolean neverTrimmed = true;

    public MapPointer(@Nullable AxiomType<?> t, @Nullable OWLAxiomVisitorEx<?> v, boolean initialized, Internals i) {
        this.type = t;
        this.visitor = v;
        this.initialized = initialized;
        this.i = (Internals)OWLAPIPreconditions.checkNotNull((Object)i, (String)"i cannot be null");
    }

    public void forEach(BiConsumer<K, V> consumer) {
        this.keySet().forEach((? super T k) -> this.forEach(k, v -> consumer.accept(k, v)));
    }

    public synchronized boolean containsReference(OWLEntity e) {
        return this.map.containsKey((Object)e);
    }

    public synchronized boolean containsReference(IRI e) {
        Set<IRI> set = null;
        if (this.iris != null) {
            set = this.iris.get();
        }
        if (set == null) {
            set = this.initSet();
        }
        return set.contains(e);
    }

    private Set<IRI> initSet() {
        Set set = CollectionFactory.createSet();
        for (Object k : this.map.keySet()) {
            if (k instanceof HasIRI) {
                set.add(((HasIRI)k).getIRI());
                continue;
            }
            if (!(k instanceof IRI)) continue;
            set.add((IRI)k);
        }
        this.iris = new SoftReference<Set>(set);
        return set;
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    public synchronized MapPointer<K, V> init() {
        if (this.initialized) {
            return this;
        }
        this.initialized = true;
        if (this.visitor == null || this.type == null) {
            return this;
        }
        if (this.visitor instanceof InitVisitorFactory.InitVisitor) {
            this.i.getAxiomsByType().forEach((AxiomType<?>)OWLAPIPreconditions.verifyNotNull(this.type), ax -> this.putInternal(ax.accept((OWLAxiomVisitorEx)((InitVisitorFactory.InitVisitor)OWLAPIPreconditions.verifyNotNull(this.visitor))), ax));
        } else if (this.visitor instanceof InitVisitorFactory.InitCollectionVisitor) {
            this.i.getAxiomsByType().forEach((AxiomType<?>)OWLAPIPreconditions.verifyNotNull(this.type), ax -> ((Stream)ax.accept((OWLAxiomVisitorEx)((InitVisitorFactory.InitCollectionVisitor)OWLAPIPreconditions.verifyNotNull(this.visitor)))).forEach((? super T key) -> this.putInternal(key, ax)));
        }
        return this;
    }

    public synchronized String toString() {
        return this.initialized + this.map.toString();
    }

    public synchronized Collection<K> keySet() {
        this.init();
        Set keySet = this.map.keySet();
        assert (keySet != null);
        return keySet;
    }

    public synchronized Stream<V> getValues(K key) {
        this.init();
        Collection t = (Collection)this.map.get(key);
        if (t == null) {
            return Stream.empty();
        }
        if (t.size() < 3) {
            return t.stream();
        }
        return new ArrayList(t).stream();
    }

    public synchronized void forEach(K key, Consumer<V> function) {
        this.init();
        this.get(key).forEach(function);
    }

    public synchronized boolean matchOnValues(K key, Predicate<V> function) {
        this.init();
        return this.get(key).anyMatch(function);
    }

    public synchronized Collection<V> getValuesAsCollection(K key) {
        this.init();
        return this.getCollection(key);
    }

    private Collection<V> getCollection(K k) {
        Collection t = (Collection)this.map.get(k);
        if (t == null) {
            return Collections.emptySet();
        }
        return new ArrayList(t);
    }

    public synchronized int countValues(K key) {
        this.init();
        return this.count(key);
    }

    private int count(K k) {
        Collection t = (Collection)this.map.get(k);
        if (t == null) {
            return 0;
        }
        return t.size();
    }

    public synchronized <O extends V> Stream<O> values(K key, Class<O> classType) {
        this.init();
        Collection t = (Collection)this.map.get(key);
        if (t == null) {
            return OWLAPIStreamUtils.empty();
        }
        return t.stream();
    }

    public synchronized <T> Collection<OWLAxiom> filterAxioms(OWLAxiomSearchFilter filter, T key) {
        this.init();
        ArrayList<OWLAxiom> toReturn = new ArrayList<OWLAxiom>();
        for (AxiomType at : filter.getAxiomTypes()) {
            Collection collection = (Collection)this.map.get((Object)at);
            if (collection == null) continue;
            collection.stream().filter(x -> filter.pass(x, key)).forEach(toReturn::add);
        }
        return toReturn;
    }

    public synchronized boolean hasValues(K key) {
        this.init();
        return this.map.containsKey(key);
    }

    public synchronized boolean put(K key, V value) {
        if (!this.initialized) {
            return false;
        }
        this.iris = null;
        return this.putInternal(key, value);
    }

    public synchronized boolean remove(K key, V value) {
        if (!this.initialized) {
            return false;
        }
        this.iris = null;
        return this.removeInternal(key, value);
    }

    public synchronized boolean containsKey(K key) {
        this.init();
        return this.map.containsKey(key);
    }

    public synchronized boolean contains(K key, V value) {
        this.init();
        return this.containsEntry(key, value);
    }

    public synchronized Stream<V> getAllValues() {
        this.init();
        return this.values();
    }

    public synchronized int size() {
        this.init();
        if (this.neverTrimmed) {
            this.trimToSize();
        }
        return this.size;
    }

    public synchronized boolean isEmpty() {
        this.init();
        return this.size == 0;
    }

    private boolean putInternal(@Nullable K k, V v) {
        if (k == null) {
            return false;
        }
        Object set = (SmallSet)this.map.get(k);
        if (set == null) {
            set = Collections.singleton(v);
            this.map.put(k, set);
            ++this.size;
            return true;
        }
        if (set.size() == 1) {
            if (set.contains(v)) {
                return false;
            }
            set = new SmallSet(set);
            this.map.put(k, set);
        } else if (set.size() == 3) {
            if (set.contains(v)) {
                return false;
            }
            set = this.makeSet((Collection<V>)set, v);
            this.map.put(k, set);
            ++this.size;
            return true;
        }
        boolean added = set.add(v);
        if (added) {
            ++this.size;
        }
        return added;
    }

    private boolean containsEntry(K k, V v) {
        Collection t = (Collection)this.map.get(k);
        if (t == null) {
            return false;
        }
        return t.contains(v);
    }

    private boolean removeInternal(K k, V v) {
        Collection t;
        if (this.neverTrimmed) {
            this.trimToSize();
        }
        if ((t = (Collection)this.map.get(k)) == null) {
            return false;
        }
        if (t.size() == 1) {
            if (t.contains(v)) {
                this.map.remove(k);
                --this.size;
                return true;
            }
            return false;
        }
        boolean removed = t.remove(v);
        if (removed) {
            --this.size;
        }
        if (t.isEmpty()) {
            this.map.remove(k);
        }
        return removed;
    }

    private Collection<V> makeSet(Collection<V> collection, V extra) {
        if (this.neverTrimmed) {
            ArrayList<V> list = new ArrayList<V>(collection);
            list.add(extra);
            return list;
        }
        return new THashSetForSet<V>(collection, extra, 5, 0.75f);
    }

    private Stream<V> values() {
        return this.map.values().stream().flatMap(Collection::stream);
    }

    private Stream<V> get(K k) {
        Collection t = (Collection)this.map.get(k);
        if (t == null) {
            return Stream.empty();
        }
        return t.stream();
    }

    public synchronized void trimToSize() {
        if (this.initialized) {
            this.map.trimToSize();
            this.neverTrimmed = false;
            for (Map.Entry entry : this.map.entrySet()) {
                Collection set = (Collection)entry.getValue();
                if (set instanceof ArrayList) {
                    THashSetForSet value = new THashSetForSet(5, 0.75f);
                    value.addAll(set);
                    entry.setValue(value);
                    this.size = this.size - set.size() + value.size();
                    value.trimToSize();
                    continue;
                }
                if (set instanceof THashSet) {
                    THashSet vs = (THashSet)set;
                    vs.trimToSize();
                    totalInUse.addAndGet(set.size());
                    totalAllocated.addAndGet(vs.capacity());
                    continue;
                }
                if (set instanceof SmallSet) {
                    totalInUse.addAndGet(set.size());
                    totalAllocated.addAndGet(3L);
                    continue;
                }
                totalInUse.addAndGet(1L);
                totalAllocated.addAndGet(1L);
            }
        }
    }

    static synchronized void resetCounts() {
        totalAllocated.set(0L);
        totalInUse.set(0L);
    }

    static synchronized long getTotalInUse() {
        return totalInUse.get();
    }

    static synchronized long getTotalAllocated() {
        return totalAllocated.get();
    }

    private static class THashSetForSet<E>
    extends THashSet<E> {
        private boolean constructing = true;

        public THashSetForSet(Collection<E> set, E toAdd, int capacity, float load) {
            super(capacity, load);
            for (E e : set) {
                this.add(e);
            }
            this.add(toAdd);
            this.constructing = false;
        }

        public THashSetForSet(int capacity, float load) {
            super(capacity, load);
            this.constructing = false;
        }

        protected boolean equals(@Nullable Object notnull, @Nullable Object two) {
            if (this.constructing) {
                return notnull == two;
            }
            return super.equals(notnull, two);
        }

        public Stream<E> stream() {
            return new ArrayList(this).stream();
        }
    }
}

