/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.DataRangeType;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRangeVisitor;
import org.semanticweb.owlapi.model.OWLDataRangeVisitorEx;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithoutEntityAndAnonCaching;

public class OWLDatatypeImpl
extends OWLObjectImplWithoutEntityAndAnonCaching
implements OWLDatatype {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final IRI iri;
    private final boolean top;
    private final boolean builtin;

    @Override
    protected int index() {
        return 4001;
    }

    public OWLDatatypeImpl(@Nonnull IRI iri) {
        this.iri = (IRI)OWLAPIPreconditions.checkNotNull((Object)iri, (String)"iri cannot be null");
        this.top = iri.equals((Object)OWLRDFVocabulary.RDFS_LITERAL.getIRI());
        this.builtin = this.top || OWL2Datatype.isBuiltIn((IRI)iri) || iri.equals((Object)OWLRDFVocabulary.RDF_PLAIN_LITERAL.getIRI());
    }

    @Override
    public boolean isTopEntity() {
        return this.top;
    }

    public boolean isRDFPlainLiteral() {
        return this.iri.isPlainLiteral();
    }

    public EntityType<?> getEntityType() {
        return EntityType.DATATYPE;
    }

    public boolean isType(EntityType<?> entityType) {
        return this.getEntityType().equals(entityType);
    }

    public String toStringID() {
        return this.iri.toString();
    }

    public IRI getIRI() {
        return this.iri;
    }

    public boolean isBuiltIn() {
        return this.builtin;
    }

    public DataRangeType getDataRangeType() {
        return DataRangeType.DATATYPE;
    }

    public OWL2Datatype getBuiltInDatatype() {
        if (!this.builtin) {
            throw new OWLRuntimeException(this.iri + " is not a built in datatype.  The getBuiltInDatatype() method should only be called on built in datatypes.");
        }
        return OWL2Datatype.getDatatype((IRI)this.iri);
    }

    public boolean isDouble() {
        return this.iri.equals((Object)OWL2Datatype.XSD_DOUBLE.getIRI());
    }

    public boolean isFloat() {
        return this.iri.equals((Object)OWL2Datatype.XSD_FLOAT.getIRI());
    }

    public boolean isInteger() {
        return this.iri.equals((Object)OWL2Datatype.XSD_INTEGER.getIRI());
    }

    public boolean isString() {
        return this.iri.equals((Object)OWL2Datatype.XSD_STRING.getIRI());
    }

    public boolean isBoolean() {
        return this.iri.equals((Object)OWL2Datatype.XSD_BOOLEAN.getIRI());
    }

    public boolean isDatatype() {
        return true;
    }

    public boolean isTopDatatype() {
        return this.top;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OWLDatatype) {
            return ((OWLDatatype)obj).getIRI().equals((Object)this.getIRI());
        }
        return false;
    }

    public OWLClass asOWLClass() {
        throw new OWLRuntimeException("Not an OWLClass!");
    }

    public OWLDataProperty asOWLDataProperty() {
        throw new OWLRuntimeException("Not a data property!");
    }

    public OWLDatatype asOWLDatatype() {
        return this;
    }

    public OWLNamedIndividual asOWLNamedIndividual() {
        throw new OWLRuntimeException("Not an individual!");
    }

    public OWLObjectProperty asOWLObjectProperty() {
        throw new OWLRuntimeException("Not an object property");
    }

    public boolean isOWLClass() {
        return false;
    }

    public boolean isOWLDataProperty() {
        return false;
    }

    public boolean isOWLDatatype() {
        return true;
    }

    public boolean isOWLNamedIndividual() {
        return false;
    }

    public boolean isOWLObjectProperty() {
        return false;
    }

    public OWLAnnotationProperty asOWLAnnotationProperty() {
        throw new OWLRuntimeException("Not an annotation property");
    }

    public boolean isOWLAnnotationProperty() {
        return false;
    }

    public void accept(OWLEntityVisitor visitor) {
        visitor.visit((OWLDatatype)this);
    }

    public void accept(OWLDataVisitor visitor) {
        visitor.visit((OWLDatatype)this);
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLDatatype)this);
    }

    public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit((OWLDatatype)this);
    }

    public <O> O accept(OWLNamedObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDatatype)this);
    }

    public <O> O accept(OWLEntityVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDatatype)this);
    }

    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDatatype)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDatatype)this);
    }

    public void accept(OWLDataRangeVisitor visitor) {
        visitor.visit((OWLDatatype)this);
    }

    public <O> O accept(OWLDataRangeVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDatatype)this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        return this.iri.compareTo((OWLObject)((OWLDatatype)object).getIRI());
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add((OWLEntity)this);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
    }
}

