/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import com.google.gwt.user.client.rpc.SerializationStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;

public class CustomFieldSerializerUtil {
    private static <T> void serializeCollection(Collection<T> set, SerializationStreamWriter writer) throws SerializationException {
        writer.writeInt(set.size());
        for (T object : set) {
            writer.writeObject(object);
        }
    }

    public static <T> void serializeSet(Set<T> set, SerializationStreamWriter writer) throws SerializationException {
        CustomFieldSerializerUtil.serializeCollection(set, writer);
    }

    public static <T> Set<T> deserializeSet(SerializationStreamReader reader) throws SerializationException {
        List<T> elements = CustomFieldSerializerUtil.derserializeCollection(reader);
        if (elements.isEmpty()) {
            return Collections.emptySet();
        }
        return CollectionFactory.createSet(elements);
    }

    private static <T> List<T> derserializeCollection(SerializationStreamReader reader) throws SerializationException {
        int size = reader.readInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> elements = new ArrayList<Object>();
        for (int i = 0; i < size; ++i) {
            Object object = reader.readObject();
            elements.add(object);
        }
        return elements;
    }

    public static <A extends OWLAxiom> void serializeAnnotations(A axiom, SerializationStreamWriter writer) throws SerializationException {
        Set annotations = axiom.getAnnotations();
        CustomFieldSerializerUtil.serializeSet(annotations, writer);
    }

    public static Set<OWLAnnotation> deserializeAnnotations(SerializationStreamReader reader) throws SerializationException {
        return CustomFieldSerializerUtil.deserializeSet(reader);
    }
}

