/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.search;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.HasObject;
import org.semanticweb.owlapi.model.HasOntologyID;
import org.semanticweb.owlapi.model.HasProperty;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLPropertyAssertionObject;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.search.DomainVisitor;
import org.semanticweb.owlapi.search.EquivalentVisitor;
import org.semanticweb.owlapi.search.RangeVisitor;
import org.semanticweb.owlapi.search.SupSubVisitor;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public final class Searcher {
    private Searcher() {
    }

    private static boolean filter(@Nullable OWLPropertyExpression p, HasProperty<?> ax) {
        return p == null || ax.getProperty().equals(p);
    }

    private static <T extends OWLPropertyAssertionObject> Stream<T> filterValues(Stream<? extends OWLPropertyAssertionAxiom<?, T>> stream, @Nullable OWLPropertyExpression p) {
        return stream.filter(ax -> Searcher.filter(p, ax)).map(HasObject::getObject).distinct();
    }

    public static Stream<OWLLiteral> values(Stream<OWLDataPropertyAssertionAxiom> axioms, @Nullable OWLDataPropertyExpression p) {
        return Searcher.filterValues(axioms, p);
    }

    public static Stream<OWLIndividual> values(Stream<OWLObjectPropertyAssertionAxiom> axioms, @Nullable OWLObjectPropertyExpression p) {
        return Searcher.filterValues(axioms, p);
    }

    public static Stream<OWLLiteral> negValues(Stream<OWLNegativeDataPropertyAssertionAxiom> axioms, @Nullable OWLDataPropertyExpression p) {
        return Searcher.filterValues(axioms, p);
    }

    public static Stream<OWLIndividual> negValues(Stream<OWLNegativeObjectPropertyAssertionAxiom> axioms, @Nullable OWLObjectPropertyExpression p) {
        return Searcher.filterValues(axioms, p);
    }

    public static Stream<OWLClassExpression> types(Stream<OWLClassAssertionAxiom> axioms) {
        return axioms.map(OWLClassAssertionAxiom::getClassExpression);
    }

    public static Stream<OWLIndividual> instances(Stream<OWLClassAssertionAxiom> axioms) {
        return axioms.map(OWLClassAssertionAxiom::getIndividual);
    }

    public static Stream<OWLObjectPropertyExpression> inverse(Stream<OWLInverseObjectPropertiesAxiom> axioms, OWLObjectPropertyExpression p) {
        return axioms.map(ax -> Searcher.getInverse(p, ax));
    }

    protected static OWLObjectPropertyExpression getInverse(OWLObjectPropertyExpression p, OWLInverseObjectPropertiesAxiom ax) {
        if (ax.getFirstProperty().equals(p)) {
            return ax.getSecondProperty();
        }
        return ax.getFirstProperty();
    }

    public static Stream<OWLAnnotationValue> values(Stream<OWLAnnotation> annotations) {
        return Searcher.values(annotations, null);
    }

    public static Stream<OWLAnnotationValue> values(Stream<OWLAnnotation> annotations, @Nullable OWLAnnotationProperty p) {
        return annotations.filter(ax -> Searcher.filter(p, ax)).map(ax -> ax.getValue());
    }

    public static Stream<OWLAnnotation> annotations(Stream<? extends OWLAxiom> axioms) {
        return Searcher.annotations(axioms, null);
    }

    public static Stream<OWLAnnotation> annotationObjects(Stream<OWLAnnotationAssertionAxiom> axioms, @Nullable OWLAnnotationProperty p) {
        return axioms.flatMap(ax -> Searcher.annotationObject(ax, p)).distinct();
    }

    public static Stream<OWLAnnotation> annotationObject(OWLAnnotationAssertionAxiom axiom, @Nullable OWLAnnotationProperty p) {
        if (p == null || ((OWLAnnotationProperty)axiom.getProperty()).equals(p)) {
            return Stream.of(axiom.getAnnotation());
        }
        return Stream.empty();
    }

    public static Stream<OWLAnnotation> annotationObjects(Stream<OWLAnnotationAssertionAxiom> axioms) {
        return axioms.map(OWLAnnotationAssertionAxiom::getAnnotation).distinct();
    }

    public static Stream<OWLAnnotation> annotations(Stream<? extends OWLAxiom> axioms, @Nullable OWLAnnotationProperty p) {
        return axioms.flatMap(ax -> Searcher.annotations(ax, p)).distinct();
    }

    public static Stream<OWLAnnotation> annotations(OWLAxiom axiom, @Nullable OWLAnnotationProperty p) {
        Stream<Object> stream = OWLAPIStreamUtils.empty();
        if (axiom instanceof OWLAnnotationAssertionAxiom) {
            stream = Stream.of(((OWLAnnotationAssertionAxiom)axiom).getAnnotation());
        }
        stream = Stream.concat(stream, axiom.annotations()).distinct().sorted();
        if (p != null) {
            stream = stream.filter(a -> a.getProperty().equals(p));
        }
        return stream.distinct();
    }

    public static <C extends OWLObject> Stream<C> equivalent(Stream<? extends OWLAxiom> axioms) {
        return Searcher.equivalent(axioms, OWLObject.class);
    }

    public static <C extends OWLObject> Stream<C> equivalent(Stream<? extends OWLAxiom> axioms, Class<C> type) {
        return axioms.flatMap(ax -> Searcher.equivalent(ax, type));
    }

    public static <C extends OWLObject> Stream<C> equivalent(OWLAxiom axiom) {
        return (Stream)axiom.accept(new EquivalentVisitor(true));
    }

    public static <C extends OWLObject> Stream<C> equivalent(OWLAxiom axiom, Class<C> type) {
        return (Stream)axiom.accept(new EquivalentVisitor(true));
    }

    public static <C extends OWLObject> Stream<C> different(Stream<? extends OWLAxiom> axioms) {
        return Searcher.different(axioms, OWLObject.class);
    }

    public static <C extends OWLObject> Stream<C> different(Stream<? extends OWLAxiom> axioms, Class<C> type) {
        return axioms.flatMap(ax -> Searcher.different(ax, type));
    }

    public static <C extends OWLObject> Stream<C> different(OWLAxiom axiom) {
        return (Stream)axiom.accept(new EquivalentVisitor(false));
    }

    public static <C extends OWLObject> Stream<C> different(OWLAxiom axiom, Class<C> type) {
        return (Stream)axiom.accept(new EquivalentVisitor(false));
    }

    public static <C extends OWLObject> Stream<C> sub(Stream<? extends OWLAxiom> axioms) {
        return Searcher.sub(axioms, OWLObject.class);
    }

    public static <C extends OWLObject> Stream<C> sub(Stream<? extends OWLAxiom> axioms, Class<C> type) {
        return axioms.map(ax -> Searcher.sub(ax, type));
    }

    public static <C extends OWLObject> C sub(OWLAxiom axiom) {
        return (C)((OWLObject)axiom.accept(new SupSubVisitor(false)));
    }

    public static <C extends OWLObject> C sub(OWLAxiom axiom, Class<C> type) {
        return (C)((OWLObject)axiom.accept(new SupSubVisitor(false)));
    }

    public static <C extends OWLObject> Stream<C> sup(Stream<? extends OWLAxiom> axioms, Class<C> type) {
        return axioms.map(ax -> Searcher.sup(ax, type));
    }

    public static <C extends OWLObject> Stream<C> sup(Stream<? extends OWLAxiom> axioms) {
        return Searcher.sup(axioms, OWLObject.class);
    }

    public static <C extends OWLObject> C sup(OWLAxiom axiom) {
        return (C)((OWLObject)axiom.accept(new SupSubVisitor(true)));
    }

    public static <C extends OWLObject> C sup(OWLAxiom axiom, Class<C> type) {
        return (C)((OWLObject)axiom.accept(new SupSubVisitor(true)));
    }

    public static <C extends OWLObject> Stream<C> domain(Stream<? extends OWLAxiom> axioms) {
        return Searcher.domain(axioms, OWLObject.class);
    }

    public static <C extends OWLObject> Stream<C> domain(Stream<? extends OWLAxiom> axioms, Class<C> type) {
        return axioms.map(ax -> Searcher.domain(ax, type));
    }

    public static <C extends OWLObject> C domain(OWLAxiom axiom) {
        return (C)((OWLObject)axiom.accept(new DomainVisitor()));
    }

    public static <C extends OWLObject> C domain(OWLAxiom axiom, Class<C> type) {
        return (C)((OWLObject)axiom.accept(new DomainVisitor()));
    }

    public static <C extends OWLObject> Stream<C> range(Stream<? extends OWLAxiom> axioms) {
        return Searcher.range(axioms, OWLObject.class);
    }

    public static <C extends OWLObject> Stream<C> range(Stream<? extends OWLAxiom> axioms, Class<C> type) {
        return axioms.map(ax -> Searcher.range(ax, type));
    }

    public static <C extends OWLObject> C range(OWLAxiom axiom) {
        return (C)((OWLObject)axiom.accept(new RangeVisitor()));
    }

    public static <C extends OWLObject> C range(OWLAxiom axiom, Class<C> type) {
        return (C)((OWLObject)axiom.accept(new RangeVisitor()));
    }

    public static Stream<IRI> ontologiesIRIs(Stream<OWLOntology> ontologies) {
        return Searcher.ontologyIRIs(ontologies.map(HasOntologyID::getOntologyID));
    }

    public static Stream<IRI> ontologyIRIs(Stream<OWLOntologyID> ids) {
        return ids.filter(i -> i.getOntologyIRI().isPresent()).map(i -> i.getOntologyIRI().get());
    }
}

