/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.modularity;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.modularity.ModuleExtractor;

public abstract class AbstractModuleExtractor
implements ModuleExtractor {
    @Nonnull
    private final Set<OWLAxiom> axiomBase;
    @Nonnull
    private Optional<Set<OWLAxiom>> globals = Optional.empty();
    @Nonnull
    private Optional<Set<OWLAxiom>> tautologies = Optional.empty();

    protected AbstractModuleExtractor(Stream<OWLAxiom> axiomBase) {
        this.axiomBase = axiomBase.filter(OWLAxiom::isLogicalAxiom).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public final Stream<OWLAxiom> axiomBase() {
        return this.axiomBase.stream();
    }

    @Override
    public boolean containsAxiom(OWLAxiom axiom) {
        return this.axiomBase.contains(axiom);
    }

    @Override
    public final boolean everyModuleContains(OWLAxiom axiom) {
        if (this.globals.isPresent()) {
            return this.globals.get().contains(axiom);
        }
        return ModuleExtractor.super.everyModuleContains(axiom);
    }

    @Override
    @Nonnull
    public final Stream<OWLAxiom> globals() {
        if (!this.globals.isPresent()) {
            this.globals = Optional.of(ModuleExtractor.super.globals().collect(Collectors.toSet()));
        }
        return this.globals.get().stream();
    }

    @Override
    public final boolean noModuleContains(OWLAxiom axiom) {
        if (this.tautologies.isPresent()) {
            return this.tautologies.get().contains(axiom);
        }
        return ModuleExtractor.super.noModuleContains(axiom);
    }

    @Override
    @Nonnull
    public final Stream<OWLAxiom> tautologies() {
        if (!this.tautologies.isPresent()) {
            this.tautologies = Optional.of(ModuleExtractor.super.tautologies().collect(Collectors.toSet()));
        }
        return this.tautologies.get().stream();
    }
}

