/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.latex.renderer;

import java.io.StringWriter;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLObjectRenderer;
import org.semanticweb.owlapi.latex.renderer.LatexObjectVisitor;
import org.semanticweb.owlapi.latex.renderer.LatexWriter;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class LatexOWLObjectRenderer
implements OWLObjectRenderer {
    private final OWLDataFactory dataFactory;
    @Nullable
    private ShortFormProvider shortFormProvider;

    public LatexOWLObjectRenderer(OWLDataFactory dataFactory) {
        this.dataFactory = OWLAPIPreconditions.checkNotNull(dataFactory);
    }

    @Override
    public String render(OWLObject object) {
        StringWriter writer = new StringWriter();
        LatexWriter latexWriter = new LatexWriter(writer);
        LatexObjectVisitor visitor = new LatexObjectVisitor(latexWriter, this.dataFactory);
        visitor.setShortFormProvider(OWLAPIPreconditions.verifyNotNull(this.shortFormProvider, "shortFormProvider not set yet"));
        object.accept(visitor);
        return writer.getBuffer().toString();
    }

    @Override
    public void setShortFormProvider(ShortFormProvider shortFormProvider) {
        this.shortFormProvider = shortFormProvider;
    }
}

