/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.krss1.parser;

import java.io.IOException;
import java.io.Reader;
import org.semanticweb.owlapi.formats.KRSSDocumentFormat;
import org.semanticweb.owlapi.formats.KRSSDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.DocumentSources;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.krss1.parser.KRSSOWLParserException;
import org.semanticweb.owlapi.krss1.parser.KRSSParser;
import org.semanticweb.owlapi.krss1.parser.ParseException;
import org.semanticweb.owlapi.krss1.parser.StreamProvider;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;

public class KRSSOWLParser
extends AbstractOWLParser {
    @Override
    public OWLDocumentFormatFactory getSupportedFormat() {
        return new KRSSDocumentFormatFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OWLDocumentFormat parse(OWLOntologyDocumentSource source, OWLOntology ontology, OWLOntologyLoaderConfiguration config) {
        try (Reader r = DocumentSources.wrapInputAsReader(source, config);){
            KRSSDocumentFormat format = new KRSSDocumentFormat();
            KRSSParser parser = new KRSSParser(new StreamProvider(r));
            parser.setOntology(ontology);
            parser.parse();
            KRSSDocumentFormat kRSSDocumentFormat = format;
            return kRSSDocumentFormat;
        }
        catch (IOException | OWLOntologyInputSourceException | ParseException e) {
            throw new KRSSOWLParserException(e);
        }
    }
}

