/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo12.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.coode.owlapi.obo12.parser.IDSpaceManager;
import org.coode.owlapi.obo12.parser.OBOIDConstants;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

enum OBOIdType implements OBOIDConstants
{
    URL_AS_ID(URL_AS_ID_PATTERN, (ontologyID, idSpaceManager, id) -> IRI.create(id)),
    UNPREFIXED_ID(UNPREFIXED_ID_PATTERN, (ontologyID, idSpaceManager, id) -> {
        String ns = !ontologyID.isAnonymous() ? ontologyID.getOntologyIRI() + "#" : "anonymous#";
        return IRI.create(ns, id);
    }),
    CANONICAL_PREFIXED_ID(CANONICAL_PREFIXED_ID_PATTERN, (ontologyID, idSpaceManager, id) -> {
        Matcher matcher = CANONICAL_PREFIXED_ID_PATTERN.matcher(id);
        matcher.matches();
        String idspace = matcher.group(1);
        String localid = matcher.group(2);
        String iriPrefix = idSpaceManager.getIRIPrefix(idspace);
        return IRI.create(iriPrefix, idspace + "_" + localid);
    }),
    NON_CANONICAL_PREFIXED_ID(NON_CANONICAL_PREFIXED_ID_ID_PATTERN, (ontologyID, idSpaceManager, id) -> {
        Matcher matcher = NON_CANONICAL_PREFIXED_ID_ID_PATTERN.matcher(id);
        matcher.matches();
        String idspace = matcher.group(1);
        String localid = matcher.group(2);
        String iriPrefix = idSpaceManager.getIRIPrefix(idspace);
        return IRI.create(iriPrefix + idspace + "#", "_" + localid);
    });

    private Pattern pattern;
    private OBOIIdTranslator translator;

    private OBOIdType(Pattern pattern, OBOIIdTranslator translator) {
        this.pattern = pattern;
        this.translator = translator;
    }

    @Nullable
    public static OBOIdType getIdType(String oboId) {
        OWLAPIPreconditions.checkNotNull(oboId, "oboId must not be null");
        for (OBOIdType idType : OBOIdType.values()) {
            Pattern pattern = idType.getPattern();
            Matcher matcher = pattern.matcher(oboId);
            if (!matcher.matches()) continue;
            return idType;
        }
        return null;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public IRI getIRIFromOBOId(OWLOntologyID ontologyID, IDSpaceManager idSpaceManager, String oboId) {
        return this.translator.getIRIFromOBOId(ontologyID, idSpaceManager, oboId);
    }

    private static interface OBOIIdTranslator {
        public IRI getIRIFromOBOId(OWLOntologyID var1, IDSpaceManager var2, String var3);
    }
}

