/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.List;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.owl.owlapi.OWLAnonymousClassExpressionImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectUnionOfImpl;

public class OWLObjectOneOfImpl
extends OWLAnonymousClassExpressionImpl
implements OWLObjectOneOf {
    private final List<OWLIndividual> values;

    public OWLObjectOneOfImpl(Stream<OWLIndividual> values) {
        OWLAPIPreconditions.checkNotNull(values, "values cannot be null");
        this.values = CollectionFactory.sortOptionally(OWLAPIStreamUtils.asListNullsForbidden(values.distinct()));
    }

    public OWLObjectOneOfImpl(OWLIndividual ... values) {
        this(Stream.of(values));
    }

    public OWLObjectOneOfImpl(OWLIndividual value) {
        this(Stream.of(value));
    }

    @Override
    public Stream<OWLIndividual> individuals() {
        return this.values.stream();
    }

    @Override
    public OWLClassExpression asObjectUnionOf() {
        if (this.values.size() == 1) {
            return this;
        }
        return new OWLObjectUnionOfImpl(this.individuals().map(i -> new OWLObjectOneOfImpl((OWLIndividual)i)));
    }
}

