/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Locale;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.InternalizedEntities;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternals;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplDouble;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplFloat;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplInteger;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplNoCompression;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplPlain;
import uk.ac.manchester.cs.owl.owlapi.OWLLiteralImplString;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

public class OWLDataFactoryInternalsImplNoCache
implements OWLDataFactoryInternals {
    private final OWLLiteral negativeFloatZero = this.getBasicLiteral("-0.0", InternalizedEntities.XSDFLOAT);
    private final boolean useCompression;

    public OWLDataFactoryInternalsImplNoCache(boolean useCompression) {
        this.useCompression = useCompression;
    }

    @Override
    public void purge() {
    }

    @Override
    public OWLClass getOWLClass(IRI iri) {
        return new OWLClassImpl(iri);
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        return new OWLObjectPropertyImpl(iri);
    }

    @Override
    public OWLDataProperty getOWLDataProperty(IRI iri) {
        return new OWLDataPropertyImpl(iri);
    }

    @Override
    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        return new OWLNamedIndividualImpl(iri);
    }

    @Override
    public OWLDatatype getOWLDatatype(IRI iri) {
        return new OWLDatatypeImpl(iri);
    }

    @Override
    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        return new OWLAnnotationPropertyImpl(iri);
    }

    @Override
    public OWLLiteral getOWLLiteral(float value) {
        return new OWLLiteralImplFloat(value);
    }

    @Override
    public OWLLiteral getOWLLiteral(String value) {
        if (this.useCompression) {
            return new OWLLiteralImpl(value, "", InternalizedEntities.XSDSTRING);
        }
        return new OWLLiteralImplString(value);
    }

    @Override
    public OWLLiteral getOWLLiteral(String literal, @Nullable String lang) {
        String normalisedLang = lang == null ? "" : lang.trim().toLowerCase(Locale.ENGLISH);
        if (normalisedLang.isEmpty()) {
            if (this.useCompression) {
                return new OWLLiteralImpl(literal, null, InternalizedEntities.XSDSTRING);
            }
            return new OWLLiteralImplString(literal);
        }
        if (this.useCompression) {
            return new OWLLiteralImpl(literal, normalisedLang, null);
        }
        return new OWLLiteralImplPlain(literal, normalisedLang);
    }

    @Override
    public OWLLiteral getOWLLiteral(int value) {
        return new OWLLiteralImplInteger(value);
    }

    @Override
    public OWLLiteral getOWLLiteral(boolean value) {
        return value ? InternalizedEntities.TRUELITERAL : InternalizedEntities.FALSELITERAL;
    }

    @Override
    public OWLLiteral getOWLLiteral(double value) {
        return new OWLLiteralImplDouble(value);
    }

    @Override
    public OWLLiteral getOWLLiteral(String lexicalValue, OWLDatatype datatype) {
        if (datatype.isRDFPlainLiteral() || datatype.equals(InternalizedEntities.LANGSTRING)) {
            int sep = lexicalValue.lastIndexOf(64);
            if (sep != -1) {
                String lex = lexicalValue.substring(0, sep);
                String lang = lexicalValue.substring(sep + 1);
                return OWLAPIPreconditions.verifyNotNull(this.getBasicLiteral(lex, lang, InternalizedEntities.LANGSTRING));
            }
            return OWLAPIPreconditions.verifyNotNull(this.getBasicLiteral(lexicalValue, InternalizedEntities.XSDSTRING));
        }
        return OWLAPIPreconditions.verifyNotNull(this.parseSpecialCases(lexicalValue, datatype));
    }

    protected OWLLiteral parseSpecialCases(String lexicalValue, OWLDatatype datatype) {
        OWLLiteral literal;
        try {
            literal = datatype.isString() ? this.getOWLLiteral(lexicalValue) : (datatype.isBoolean() ? this.getOWLLiteral(OWLLiteralImpl.asBoolean(lexicalValue.trim())) : (datatype.isFloat() ? this.parseFloat(lexicalValue, datatype) : (datatype.isDouble() ? this.getOWLLiteral(Double.parseDouble(lexicalValue)) : (datatype.isInteger() ? this.parseInteger(lexicalValue, datatype) : this.getBasicLiteral(lexicalValue, datatype)))));
        }
        catch (NumberFormatException e) {
            literal = this.getBasicLiteral(lexicalValue, datatype);
        }
        return literal;
    }

    protected OWLLiteral parseInteger(String lexicalValue, OWLDatatype datatype) {
        OWLLiteral literal;
        if (lexicalValue.trim().charAt(0) == '0') {
            literal = this.getBasicLiteral(lexicalValue, InternalizedEntities.XSDINTEGER);
        } else {
            try {
                literal = this.getOWLLiteral(Integer.parseInt(lexicalValue));
            }
            catch (NumberFormatException ex) {
                literal = this.getBasicLiteral(lexicalValue, datatype);
            }
        }
        return literal;
    }

    protected OWLLiteral parseFloat(String lexicalValue, OWLDatatype datatype) {
        if ("-0.0".equals(lexicalValue.trim())) {
            return this.negativeFloatZero;
        }
        try {
            float f = Float.parseFloat(lexicalValue);
            return this.getOWLLiteral(f);
        }
        catch (NumberFormatException e) {
            return this.getBasicLiteral(lexicalValue, datatype);
        }
    }

    protected OWLLiteral getBasicLiteral(String lexicalValue, OWLDatatype datatype) {
        return this.getBasicLiteral(lexicalValue, "", datatype);
    }

    protected OWLLiteral getBasicLiteral(String lexicalValue, String lang, @Nullable OWLDatatype datatype) {
        if (this.useCompression) {
            if (datatype == null || datatype.isRDFPlainLiteral() || datatype.equals(InternalizedEntities.LANGSTRING)) {
                return new OWLLiteralImplPlain(lexicalValue, lang);
            }
            return new OWLLiteralImpl(lexicalValue, lang, datatype);
        }
        return new OWLLiteralImplNoCompression(lexicalValue, lang, datatype);
    }

    @Override
    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value, Stream<OWLAnnotation> annotations) {
        return new OWLAnnotationImpl(property, value, annotations);
    }
}

