/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.decomposition;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.semanticweb.owlapi.model.HasOperands;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapitools.decomposition.AxiomWrapper;
import org.semanticweb.owlapitools.decomposition.BotEquivalenceEvaluator;
import org.semanticweb.owlapitools.decomposition.LocalityChecker;
import org.semanticweb.owlapitools.decomposition.Signature;
import org.semanticweb.owlapitools.decomposition.TopEquivalenceEvaluator;

public class SyntacticLocalityChecker
implements OWLAxiomVisitor,
LocalityChecker {
    private Signature sig = new Signature();
    TopEquivalenceEvaluator topEval = new TopEquivalenceEvaluator(this);
    BotEquivalenceEvaluator botEval = new BotEquivalenceEvaluator(this);
    boolean isLocal;

    @Override
    public boolean isTopEquivalent(OWLObject expr) {
        return this.topEval.isTopEquivalent(expr);
    }

    @Override
    public boolean isBotEquivalent(OWLObject expr) {
        return this.botEval.isBotEquivalent(expr);
    }

    @Override
    public Signature getSignature() {
        return this.sig;
    }

    @Override
    public void setSignatureValue(Signature sig) {
        this.sig = sig;
    }

    @Override
    public boolean local(OWLAxiom axiom) {
        axiom.accept(this);
        return this.isLocal;
    }

    private <T extends OWLObject> boolean processEquivalentAxiom(HasOperands<T> axiom) {
        if (axiom.operands().count() <= 1L) {
            return true;
        }
        List<OWLObject> args = OWLAPIStreamUtils.asList(axiom.operands());
        Boolean pos = null;
        for (OWLObject arg : args) {
            if (pos == null) {
                if (this.isTopEquivalent(arg)) {
                    pos = Boolean.TRUE;
                    continue;
                }
                if (this.isBotEquivalent(arg)) {
                    pos = Boolean.FALSE;
                    continue;
                }
                return false;
            }
            if (pos.booleanValue() && !this.isTopEquivalent(arg)) {
                return false;
            }
            if (pos.booleanValue() || this.isBotEquivalent(arg)) continue;
            return false;
        }
        return true;
    }

    private <T extends OWLObject> boolean processDisjointAxiom(HasOperands<T> axiom) {
        boolean hasNBE = false;
        Iterator it = axiom.operands().iterator();
        while (it.hasNext()) {
            OWLObject p = (OWLObject)it.next();
            if (this.isBotEquivalent(p)) continue;
            if (hasNBE) {
                return false;
            }
            hasNBE = true;
        }
        return true;
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        this.isLocal = true;
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.isLocal = this.processEquivalentAxiom(axiom);
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.isLocal = this.processDisjointAxiom(axiom);
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        boolean lhsIsTopEq;
        this.isLocal = false;
        if (this.isTopEquivalent(axiom.getOWLClass())) {
            lhsIsTopEq = true;
        } else if (this.isBotEquivalent(axiom.getOWLClass())) {
            lhsIsTopEq = false;
        } else {
            return;
        }
        boolean topEqDesc = false;
        for (OWLClassExpression p : OWLAPIStreamUtils.asList(axiom.classExpressions())) {
            if (this.isBotEquivalent(p)) continue;
            if (lhsIsTopEq && this.isTopEquivalent(p)) {
                if (topEqDesc) {
                    return;
                }
                topEqDesc = true;
                continue;
            }
            return;
        }
        if (lhsIsTopEq && !topEqDesc) {
            return;
        }
        this.isLocal = true;
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.isLocal = this.processEquivalentAxiom(axiom);
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.isLocal = this.processEquivalentAxiom(axiom);
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.isLocal = this.processDisjointAxiom(axiom);
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.isLocal = this.processDisjointAxiom(axiom);
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        this.isLocal = false;
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.isLocal = false;
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        OWLObjectPropertyExpression p1 = axiom.getFirstProperty();
        OWLObjectPropertyExpression p2 = axiom.getSecondProperty();
        this.isLocal = this.isBotEquivalent(p1) && this.isBotEquivalent(p2) || this.isTopEquivalent(p1) && this.isTopEquivalent(p2);
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.isLocal = this.isTopEquivalent((OWLObject)axiom.getSuperProperty()) || this.isBotEquivalent((OWLObject)axiom.getSubProperty());
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.isLocal = this.isTopEquivalent((OWLObject)axiom.getSuperProperty()) || this.isBotEquivalent((OWLObject)axiom.getSubProperty());
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.isLocal = this.isTopEquivalent((OWLObject)axiom.getDomain()) || this.isBotEquivalent((OWLObject)axiom.getProperty());
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.isLocal = this.isTopEquivalent((OWLObject)axiom.getDomain()) || this.isBotEquivalent((OWLObject)axiom.getProperty());
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.isLocal = this.isTopEquivalent((OWLObject)axiom.getRange()) || this.isBotEquivalent((OWLObject)axiom.getProperty());
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.isLocal = this.isTopEquivalent((OWLObject)axiom.getRange()) || this.isBotEquivalent((OWLObject)axiom.getProperty());
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.isLocal = this.isBotEquivalent((OWLObject)axiom.getProperty()) || this.isTopEquivalent((OWLObject)axiom.getProperty());
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.isLocal = this.isTopEquivalent((OWLObject)axiom.getProperty());
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.isLocal = this.isBotEquivalent((OWLObject)axiom.getProperty());
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.isLocal = this.isBotEquivalent((OWLObject)axiom.getProperty()) || this.isTopEquivalent((OWLObject)axiom.getProperty());
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.isLocal = this.isBotEquivalent((OWLObject)axiom.getProperty());
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.isLocal = this.isBotEquivalent((OWLObject)axiom.getProperty());
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.isLocal = this.isBotEquivalent((OWLObject)axiom.getProperty());
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.isLocal = this.isBotEquivalent((OWLObject)axiom.getProperty());
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        this.isLocal = this.isBotEquivalent(axiom.getSubClass()) || this.isTopEquivalent(axiom.getSuperClass());
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        this.isLocal = this.isTopEquivalent(axiom.getClassExpression());
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.isLocal = this.isTopEquivalent(axiom.getProperty());
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.isLocal = this.isBotEquivalent(axiom.getProperty());
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.isLocal = this.isTopEquivalent((OWLObject)axiom.getObject());
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.isLocal = this.isBotEquivalent((OWLObject)axiom.getObject());
    }

    @Override
    public void preprocessOntology(Collection<AxiomWrapper> s) {
        this.sig = new Signature();
        s.forEach(ax -> this.sig.addAll(ax.getAxiom().signature()));
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.isLocal = true;
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.isLocal = true;
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.isLocal = true;
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.isLocal = true;
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.isLocal = true;
        if (this.isTopEquivalent(axiom.getSuperProperty())) {
            return;
        }
        for (OWLObjectPropertyExpression R : axiom.getPropertyChain()) {
            if (!this.isBotEquivalent(R)) continue;
            return;
        }
        this.isLocal = false;
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
        this.isLocal = true;
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.isLocal = true;
    }

    @Override
    public void visit(SWRLRule rule) {
        this.isLocal = true;
    }
}

