/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders;

import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapitools.builders.BaseBuilder;

public abstract class BaseEntityBuilder<T extends OWLEntity, B>
extends BaseBuilder<T, B> {
    @Nullable
    private IRI iri = null;
    @Nullable
    protected String string = null;
    @Nullable
    protected PrefixManager pm = null;

    @Inject
    public BaseEntityBuilder(OWLDataFactory df) {
        super(df);
    }

    public B withIRI(IRI arg) {
        this.iri = arg;
        return (B)this;
    }

    public B withPrefixManager(PrefixManager arg) {
        this.pm = arg;
        return (B)this;
    }

    public B withPrefixedIRI(String arg) {
        this.string = arg;
        return (B)this;
    }

    public IRI getIRI() {
        return OWLAPIPreconditions.verifyNotNull(this.iri);
    }

    public String getString() {
        return OWLAPIPreconditions.verifyNotNull(this.string);
    }

    public PrefixManager getPM() {
        return OWLAPIPreconditions.verifyNotNull(this.pm);
    }
}

