/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model.providers;

import java.util.Collection;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.providers.LiteralProvider;
import org.semanticweb.owlapi.model.providers.OWLVocabularyProvider;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.OWLFacet;

public interface DatatypeExpressionProvider
extends LiteralProvider,
OWLVocabularyProvider {
    public OWLDatatypeRestriction getOWLDatatypeRestriction(OWLDatatype var1, Collection<OWLFacetRestriction> var2);

    public OWLDatatypeRestriction getOWLDatatypeRestriction(OWLDatatype var1, OWLFacet var2, OWLLiteral var3);

    default public OWLDatatypeRestriction getOWLDatatypeRestriction(OWLDatatype dataType, OWLFacetRestriction ... facetRestrictions) {
        OWLAPIPreconditions.checkIterableNotNull(facetRestrictions, "facetRestrictions cannot be null", true);
        return this.getOWLDatatypeRestriction(dataType, CollectionFactory.createSet(facetRestrictions));
    }

    default public OWLDatatypeRestriction getOWLDatatypeMinInclusiveRestriction(int minInclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), OWLFacet.MIN_INCLUSIVE, this.getOWLLiteral(minInclusive));
    }

    default public OWLDatatypeRestriction getOWLDatatypeMaxInclusiveRestriction(double maxInclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), OWLFacet.MAX_INCLUSIVE, this.getOWLLiteral(maxInclusive));
    }

    default public OWLDatatypeRestriction getOWLDatatypeMinMaxInclusiveRestriction(int minInclusive, int maxInclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), this.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, this.getOWLLiteral(minInclusive)), this.getOWLFacetRestriction(OWLFacet.MAX_INCLUSIVE, maxInclusive));
    }

    default public OWLDatatypeRestriction getOWLDatatypeMinExclusiveRestriction(int minExclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), OWLFacet.MIN_EXCLUSIVE, this.getOWLLiteral(minExclusive));
    }

    default public OWLDatatypeRestriction getOWLDatatypeMaxExclusiveRestriction(int maxExclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), OWLFacet.MAX_EXCLUSIVE, this.getOWLLiteral(maxExclusive));
    }

    default public OWLDatatypeRestriction getOWLDatatypeMinMaxExclusiveRestriction(int minExclusive, int maxExclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), this.getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, this.getOWLLiteral(minExclusive)), this.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, maxExclusive));
    }

    default public OWLDatatypeRestriction getOWLDatatypeMinInclusiveRestriction(double minInclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), OWLFacet.MIN_INCLUSIVE, this.getOWLLiteral(minInclusive));
    }

    default public OWLDatatypeRestriction getOWLDatatypeMinMaxInclusiveRestriction(double minInclusive, double maxInclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), this.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, this.getOWLLiteral(minInclusive)), this.getOWLFacetRestriction(OWLFacet.MAX_INCLUSIVE, maxInclusive));
    }

    default public OWLDatatypeRestriction getOWLDatatypeMinExclusiveRestriction(double minExclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), OWLFacet.MIN_EXCLUSIVE, this.getOWLLiteral(minExclusive));
    }

    default public OWLDatatypeRestriction getOWLDatatypeMaxInclusiveRestriction(int maxInclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), OWLFacet.MAX_INCLUSIVE, this.getOWLLiteral(maxInclusive));
    }

    default public OWLDatatypeRestriction getOWLDatatypeMaxExclusiveRestriction(double maxExclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), OWLFacet.MAX_EXCLUSIVE, this.getOWLLiteral(maxExclusive));
    }

    default public OWLDatatypeRestriction getOWLDatatypeMinMaxExclusiveRestriction(double minExclusive, double maxExclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), this.getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, this.getOWLLiteral(minExclusive)), this.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, maxExclusive));
    }

    public OWLFacetRestriction getOWLFacetRestriction(OWLFacet var1, OWLLiteral var2);

    default public OWLFacetRestriction getOWLFacetRestriction(OWLFacet facet, int facetValue) {
        return this.getOWLFacetRestriction(facet, this.getOWLLiteral(facetValue));
    }

    default public OWLFacetRestriction getOWLFacetRestriction(OWLFacet facet, double facetValue) {
        return this.getOWLFacetRestriction(facet, this.getOWLLiteral(facetValue));
    }

    default public OWLFacetRestriction getOWLFacetRestriction(OWLFacet facet, float facetValue) {
        return this.getOWLFacetRestriction(facet, this.getOWLLiteral(facetValue));
    }
}

