/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.obo2owl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.functional.parser.OWLFunctionalSyntaxOWLParser;
import org.semanticweb.owlapi.functional.renderer.OWLFunctionalSyntaxRenderer;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.io.StringDocumentSource;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class OwlStringTools {
    private OwlStringTools() {
    }

    public static String translate(Collection<OWLAxiom> axioms, OWLOntologyManager translationManager) {
        if (axioms.isEmpty()) {
            return "";
        }
        try {
            OWLOntology ontology = translationManager.createOntology();
            ontology.add(axioms);
            OWLFunctionalSyntaxRenderer r = new OWLFunctionalSyntaxRenderer();
            StringWriter writer = new StringWriter();
            PrintWriter w = new PrintWriter(writer);
            r.render(ontology, w);
            w.flush();
            return ((Object)writer).toString();
        }
        catch (OWLRendererException | OWLOntologyCreationException | OWLRuntimeException e) {
            throw new OwlStringException(e);
        }
    }

    public static Collection<OWLAxiom> translate(@Nullable String axioms, OWLOntologyManager translationManager) {
        if (axioms == null || axioms.isEmpty()) {
            return Collections.emptySet();
        }
        try {
            OWLFunctionalSyntaxOWLParser p = new OWLFunctionalSyntaxOWLParser();
            StringDocumentSource documentSource = new StringDocumentSource(axioms);
            OWLOntology ontology = translationManager.createOntology();
            p.parse(documentSource, ontology, translationManager.getOntologyLoaderConfiguration());
            return OWLAPIStreamUtils.asList(ontology.axioms());
        }
        catch (OWLParserException | OWLOntologyCreationException | UnloadableImportException e) {
            throw new OWLRuntimeException(e);
        }
    }

    public static class OwlStringException
    extends OWLRuntimeException {
        protected OwlStringException(Throwable cause) {
            super(cause);
        }
    }
}

