/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo12.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.coode.owlapi.obo12.parser.IDSpaceManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

enum OBOIdType {
    URL_AS_ID(Pattern.compile("(http:|https:)[^\\s]*"), (ontologyID, idSpaceManager, id) -> IRI.create((String)id)),
    UNPREFIXED_ID(Pattern.compile("[^\\s:]*"), (ontologyID, idSpaceManager, id) -> {
        String ns = !ontologyID.isAnonymous() ? ontologyID.getOntologyIRI() + "#" : "anonymous#";
        return IRI.create((String)ns, (String)id);
    }),
    CANONICAL_PREFIXED_ID(Pattern.compile("([A-Za-z][A-Za-z_]*):([0-9]*)"), new OBOIIdTranslator(){

        @Override
        public IRI getIRIFromOBOId(OWLOntologyID ontologyID, IDSpaceManager idSpaceManager, String id) {
            Matcher matcher = CANONICAL_PREFIXED_ID.getPattern().matcher(id);
            matcher.matches();
            String idspace = matcher.group(1);
            String localid = matcher.group(2);
            String iriPrefix = idSpaceManager.getIRIPrefix(idspace);
            return IRI.create((String)iriPrefix, (String)(idspace + "_" + localid));
        }
    }),
    NON_CANONICAL_PREFIXED_ID(Pattern.compile("([^\\s:]*):([^\\s]*)"), new OBOIIdTranslator(){

        @Override
        public IRI getIRIFromOBOId(OWLOntologyID ontologyID, IDSpaceManager idSpaceManager, String id) {
            Matcher matcher = NON_CANONICAL_PREFIXED_ID.getPattern().matcher(id);
            matcher.matches();
            String idspace = matcher.group(1);
            String localid = matcher.group(2);
            String iriPrefix = idSpaceManager.getIRIPrefix(idspace);
            return IRI.create((String)(iriPrefix + idspace + "#"), (String)("_" + localid));
        }
    });

    private Pattern pattern;
    private OBOIIdTranslator translator;

    private OBOIdType(Pattern pattern, OBOIIdTranslator translator) {
        this.pattern = pattern;
        this.translator = translator;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public IRI getIRIFromOBOId(OWLOntologyID ontologyID, IDSpaceManager idSpaceManager, String oboId) {
        return this.translator.getIRIFromOBOId(ontologyID, idSpaceManager, oboId);
    }

    @Nullable
    public static OBOIdType getIdType(String oboId) {
        OWLAPIPreconditions.checkNotNull((Object)oboId, (String)"oboId must not be null");
        for (OBOIdType idType : OBOIdType.values()) {
            Pattern pattern = idType.getPattern();
            Matcher matcher = pattern.matcher(oboId);
            if (!matcher.matches()) continue;
            return idType;
        }
        return null;
    }

    private static interface OBOIIdTranslator {
        public IRI getIRIFromOBOId(OWLOntologyID var1, IDSpaceManager var2, String var3);
    }
}

