/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.apibinding;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.semanticweb.owlapi.OWLAPIParsersModule;
import org.semanticweb.owlapi.OWLAPIServiceLoaderModule;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyManagerFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.mansyntax.ManchesterOWLSyntaxParser;
import uk.ac.manchester.cs.owl.owlapi.OWLAPIImplModule;
import uk.ac.manchester.cs.owl.owlapi.concurrent.Concurrency;

public class OWLManager
implements OWLOntologyManagerFactory {
    public OWLOntologyManager get() {
        return OWLManager.createOWLOntologyManager();
    }

    public static OWLOntologyManager createOWLOntologyManager() {
        return OWLManager.instatiateOWLOntologyManager(Concurrency.NON_CONCURRENT);
    }

    public static OWLOntologyManager createConcurrentOWLOntologyManager() {
        return OWLManager.instatiateOWLOntologyManager(Concurrency.CONCURRENT);
    }

    public static OWLDataFactory getOWLDataFactory() {
        return (OWLDataFactory)OWLAPIPreconditions.verifyNotNull((Object)OWLManager.createInjector(Concurrency.NON_CONCURRENT).getInstance(OWLDataFactory.class));
    }

    public static ManchesterOWLSyntaxParser createManchesterParser() {
        return (ManchesterOWLSyntaxParser)OWLManager.createInjector(Concurrency.NON_CONCURRENT).getInstance(ManchesterOWLSyntaxParser.class);
    }

    private static Injector createInjector(Concurrency concurrency) {
        String previousStrategy = System.getProperty("guice_include_stack_traces");
        System.setProperty("guice_include_stack_traces", "OFF");
        Injector injector = Guice.createInjector((Module[])new Module[]{new OWLAPIImplModule(concurrency), new OWLAPIParsersModule(), new OWLAPIServiceLoaderModule()});
        if (previousStrategy != null) {
            System.setProperty("guice_include_stack_traces", previousStrategy);
        } else {
            System.getProperties().remove("guice_include_stack_traces");
        }
        return injector;
    }

    private static OWLOntologyManager instatiateOWLOntologyManager(Concurrency concurrency) {
        Injector injector = OWLManager.createInjector(concurrency);
        OWLOntologyManager instance = (OWLOntologyManager)injector.getInstance(OWLOntologyManager.class);
        injector.injectMembers((Object)instance);
        return (OWLOntologyManager)OWLAPIPreconditions.verifyNotNull((Object)instance);
    }
}

