/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Iterator;
import java.util.stream.Stream;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.OWLObjectRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.EscapeUtils;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class SimpleRendererDebug
implements OWLObjectVisitor,
OWLObjectRenderer {
    private StringBuilder _sb = new StringBuilder();
    private ShortFormProvider shortFormProvider;
    private IRIShortFormProvider iriShortFormProvider;

    public SimpleRendererDebug() {
        this.resetShortFormProvider();
    }

    public void reset() {
        this._sb = new StringBuilder();
    }

    private StringBuilder sb(Object o) {
        this._sb.append("(:" + System.identityHashCode(o) + ")");
        return this._sb;
    }

    public boolean isUsingDefaultShortFormProvider() {
        return this.shortFormProvider instanceof DefaultPrefixManager;
    }

    public final void resetShortFormProvider() {
        DefaultPrefixManager defaultPrefixManager = new DefaultPrefixManager();
        this.shortFormProvider = defaultPrefixManager;
        this.iriShortFormProvider = defaultPrefixManager;
    }

    public void setPrefixesFromOntologyFormat(OWLOntology ontology, boolean processImportedOntologies) {
        this.resetShortFormProvider();
        Imports.fromBoolean(processImportedOntologies).stream(ontology).forEach(o -> this.copyPrefixes(o.getNonnullFormat()));
    }

    private void copyPrefixes(OWLDocumentFormat ontologyFormat) {
        if (!(ontologyFormat instanceof PrefixDocumentFormat)) {
            return;
        }
        PrefixDocumentFormat prefixFormat = (PrefixDocumentFormat)ontologyFormat;
        if (!this.isUsingDefaultShortFormProvider()) {
            this.resetShortFormProvider();
        }
        ((DefaultPrefixManager)this.shortFormProvider).copyPrefixesFrom(prefixFormat.getPrefixName2PrefixMap());
    }

    public void setPrefix(String prefixName, String prefix) {
        if (!this.isUsingDefaultShortFormProvider()) {
            this.resetShortFormProvider();
        }
        ((DefaultPrefixManager)this.shortFormProvider).setPrefix(prefixName, prefix);
    }

    @Override
    public void setShortFormProvider(ShortFormProvider shortFormProvider) {
        this.shortFormProvider = shortFormProvider;
    }

    public String getShortForm(IRI iri) {
        return this.iriShortFormProvider.getShortForm(iri);
    }

    @Override
    public String render(OWLObject object) {
        this.reset();
        object.accept(this);
        return this._sb.toString();
    }

    protected void render(Stream<? extends OWLObject> objects) {
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            ((OWLObject)it.next()).accept(this);
            if (!it.hasNext()) continue;
            this.insertSpace();
        }
    }

    @Override
    public void visit(OWLOntology ontology) {
        this.sb(ontology).append("Ontology(").append(ontology.getOntologyID()).append(" [Axioms: ").append(ontology.getAxiomCount()).append("] [Logical axioms: ").append(ontology.getLogicalAxiomCount()).append("])");
    }

    private void insertSpace() {
        this._sb.append(' ');
    }

    public void writeAnnotations(OWLAxiom axiom) {
        axiom.annotations().forEach(a -> {
            a.accept(this);
            this.insertSpace();
        });
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        this.sb(axiom).append("SubClassOf(");
        this.writeAnnotations(axiom);
        axiom.getSubClass().accept(this);
        this.insertSpace();
        axiom.getSuperClass().accept(this);
        this.closeBracket();
    }

    protected StringBuilder closeBracket() {
        return this._sb.append(')');
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.sb(axiom).append("NegativeObjectPropertyAssertion(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        axiom.getSubject().accept(this);
        this.insertSpace();
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.sb(axiom).append("AsymmetricObjectProperty(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.sb(axiom).append("ReflexiveObjectProperty(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.sb(axiom).append("DisjointClasses(");
        this.writeAnnotations(axiom);
        this.render(axiom.classExpressions());
        this.closeBracket();
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.sb(axiom).append("DataPropertyDomain(");
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        ((OWLClassExpression)axiom.getDomain()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.sb(axiom).append("ObjectPropertyDomain(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        ((OWLClassExpression)axiom.getDomain()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.sb(axiom).append("EquivalentObjectProperties(");
        this.writeAnnotations(axiom);
        this.render(axiom.properties());
        this.closeBracket();
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.sb(axiom).append("NegativeDataPropertyAssertion(");
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        axiom.getSubject().accept(this);
        this.insertSpace();
        ((OWLLiteral)axiom.getObject()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.sb(axiom).append("DifferentIndividuals(");
        this.writeAnnotations(axiom);
        this.render(axiom.individuals());
        this.closeBracket();
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.sb(axiom).append("DisjointDataProperties(");
        this.writeAnnotations(axiom);
        this.render(axiom.properties());
        this.closeBracket();
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.sb(axiom).append("DisjointObjectProperties(");
        this.writeAnnotations(axiom);
        this.render(axiom.properties());
        this.closeBracket();
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.sb(axiom).append("ObjectPropertyRange(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        ((OWLClassExpression)axiom.getRange()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.sb(axiom).append("ObjectPropertyAssertion(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        axiom.getSubject().accept(this);
        this.insertSpace();
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.sb(axiom).append("FunctionalObjectProperty(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.sb(axiom).append("SubObjectPropertyOf(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        this.insertSpace();
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.sb(axiom).append("DisjointUnion(");
        this.writeAnnotations(axiom);
        axiom.getOWLClass().accept(this);
        this.insertSpace();
        this.render(axiom.classExpressions());
        this.closeBracket();
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        this.sb(axiom).append("Declaration(");
        this.writeAnnotations(axiom);
        OWLEntity entity = axiom.getEntity();
        if (entity.isOWLClass()) {
            this.sb(entity).append("Class(");
        } else if (entity.isOWLObjectProperty()) {
            this.sb(entity).append("ObjectProperty(");
        } else if (entity.isOWLDataProperty()) {
            this.sb(entity).append("DataProperty(");
        } else if (entity.isOWLNamedIndividual()) {
            this.sb(entity).append("NamedIndividual(");
        } else if (entity.isOWLDatatype()) {
            this.sb(entity).append("Datatype(");
        } else if (entity.isOWLAnnotationProperty()) {
            this.sb(entity).append("AnnotationProperty(");
        }
        axiom.getEntity().accept(this);
        this.closeBracket();
        this.closeBracket();
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.sb(axiom).append("AnnotationAssertion(");
        this.writeAnnotations(axiom);
        ((OWLAnnotationProperty)axiom.getProperty()).accept(this);
        this.insertSpace();
        ((OWLAnnotationSubject)axiom.getSubject()).accept(this);
        this.insertSpace();
        axiom.getValue().accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.sb(axiom).append("SymmetricObjectProperty(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.sb(axiom).append("DataPropertyRange(");
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        ((OWLDataRange)axiom.getRange()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.sb(axiom).append("FunctionalDataProperty(");
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.sb(axiom).append("EquivalentDataProperties(");
        this.writeAnnotations(axiom);
        this.render(axiom.properties());
        this.closeBracket();
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        this.sb(axiom).append("ClassAssertion(");
        this.writeAnnotations(axiom);
        axiom.getClassExpression().accept(this);
        this.insertSpace();
        axiom.getIndividual().accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.sb(axiom).append("EquivalentClasses(");
        this.writeAnnotations(axiom);
        this.render(axiom.classExpressions());
        this.closeBracket();
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.sb(axiom).append("DataPropertyAssertion(");
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.insertSpace();
        axiom.getSubject().accept(this);
        this.insertSpace();
        ((OWLLiteral)axiom.getObject()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.sb(axiom).append("TransitiveObjectProperty(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.sb(axiom).append("IrreflexiveObjectProperty(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.sb(axiom).append("SubDataPropertyOf(");
        this.writeAnnotations(axiom);
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        this.insertSpace();
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.sb(axiom).append("InverseFunctionalObjectProperty(");
        this.writeAnnotations(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        this.sb(axiom).append("SameIndividual(");
        this.writeAnnotations(axiom);
        this.render(axiom.individuals());
        this.closeBracket();
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.sb(axiom).append("SubObjectPropertyOf(");
        this.writeAnnotations(axiom);
        this._sb.append("ObjectPropertyChain(");
        for (OWLObjectPropertyExpression prop : axiom.getPropertyChain()) {
            this.insertSpace();
            prop.accept(this);
        }
        this.closeBracket();
        this.insertSpace();
        axiom.getSuperProperty().accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLClass ce) {
        this.sb(ce).append(this.shortFormProvider.getShortForm(ce));
    }

    @Override
    public void visit(OWLObjectIntersectionOf ce) {
        this.sb(ce).append("ObjectIntersectionOf(");
        this.render(ce.operands());
        this.closeBracket();
    }

    @Override
    public void visit(OWLObjectUnionOf ce) {
        this.sb(ce).append("ObjectUnionOf(");
        this.render(ce.operands());
        this.closeBracket();
    }

    @Override
    public void visit(OWLObjectComplementOf ce) {
        this.sb(ce).append("ObjectComplementOf(");
        ce.getOperand().accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom ce) {
        this.sb(ce).append("ObjectSomeValuesFrom(");
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLClassExpression)ce.getFiller()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLObjectAllValuesFrom ce) {
        this.sb(ce).append("ObjectAllValuesFrom(");
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLClassExpression)ce.getFiller()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLObjectHasValue ce) {
        this.sb(ce).append("ObjectHasValue(");
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLIndividual)ce.getFiller()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLObjectMinCardinality ce) {
        this.sb(ce).append("ObjectMinCardinality(").append(ce.getCardinality());
        this.insertSpace();
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLClassExpression)ce.getFiller()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLObjectExactCardinality ce) {
        this.sb(ce).append("ObjectExactCardinality(").append(ce.getCardinality());
        this.insertSpace();
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLClassExpression)ce.getFiller()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLObjectMaxCardinality ce) {
        this.sb(ce).append("ObjectMaxCardinality(").append(ce.getCardinality());
        this.insertSpace();
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLClassExpression)ce.getFiller()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLObjectHasSelf ce) {
        this.sb(ce).append("ObjectHasSelf(");
        ce.getProperty().accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLObjectOneOf ce) {
        this.sb(ce).append("ObjectOneOf(");
        this.render(ce.individuals());
        this.closeBracket();
    }

    @Override
    public void visit(OWLDataSomeValuesFrom ce) {
        this.sb(ce).append("DataSomeValuesFrom(");
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLDataRange)ce.getFiller()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLDataAllValuesFrom ce) {
        this.sb(ce).append("DataAllValuesFrom(");
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLDataRange)ce.getFiller()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLDataHasValue ce) {
        this.sb(ce).append("DataHasValue(");
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLLiteral)ce.getFiller()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLDataMinCardinality ce) {
        this.sb(ce).append("DataMinCardinality(").append(ce.getCardinality());
        this.insertSpace();
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLDataRange)ce.getFiller()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLDataExactCardinality ce) {
        this.sb(ce).append("DataExactCardinality(").append(ce.getCardinality());
        this.insertSpace();
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLDataRange)ce.getFiller()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLDataMaxCardinality ce) {
        this.sb(ce).append("DataMaxCardinality(").append(ce.getCardinality());
        this.insertSpace();
        ce.getProperty().accept(this);
        this.insertSpace();
        ((OWLDataRange)ce.getFiller()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLDatatype node) {
        this.sb(node).append(this.shortFormProvider.getShortForm(node));
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.sb(node).append("DataComplementOf(");
        node.getDataRange().accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.sb(node).append("DataOneOf(");
        this.render(node.values());
        this.closeBracket();
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
        this.sb(node).append("DataRangeRestriction(");
        node.getDatatype().accept(this);
        node.facetRestrictions().forEach(r -> {
            this.insertSpace();
            r.accept(this);
        });
        this.closeBracket();
    }

    @Override
    public void visit(OWLFacetRestriction node) {
        this.sb(node).append("facetRestriction(").append(node.getFacet());
        this.insertSpace();
        node.getFacetValue().accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLLiteral node) {
        StringBuilder sb = this.sb(node);
        String literal = EscapeUtils.escapeString(node.getLiteral());
        if (node.isRDFPlainLiteral() || node.getDatatype().getIRI().equals(OWL2Datatype.RDF_LANG_STRING.getIRI())) {
            sb.append('\"').append(literal).append('\"');
            if (node.hasLang()) {
                sb.append('@').append(node.getLang());
            }
        } else {
            sb.append('\"').append(literal).append("\"^^");
            node.getDatatype().accept(this);
        }
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.sb(property).append(this.shortFormProvider.getShortForm(property));
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.sb(property).append("ObjectInverseOf(");
        property.getInverse().accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.sb(property).append(this.shortFormProvider.getShortForm(property));
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.sb(individual).append(this.shortFormProvider.getShortForm(individual));
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.sb(axiom).append("InverseObjectProperties(");
        this.writeAnnotations(axiom);
        axiom.getFirstProperty().accept(this);
        this.insertSpace();
        axiom.getSecondProperty().accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
        this.sb(axiom).append("HasKey(");
        this.writeAnnotations(axiom);
        axiom.getClassExpression().accept(this);
        this._sb.append(" (");
        axiom.objectPropertyExpressions().forEach(p -> {
            p.accept(this);
            this.insertSpace();
        });
        this._sb.append(") (");
        axiom.dataPropertyExpressions().forEach(p -> {
            p.accept(this);
            this.insertSpace();
        });
        this.closeBracket();
        this.closeBracket();
    }

    @Override
    public void visit(OWLDataIntersectionOf node) {
        this.sb(node).append("DataIntersectionOf(");
        node.operands().forEach(r -> {
            r.accept(this);
            this.insertSpace();
        });
        this.closeBracket();
    }

    @Override
    public void visit(OWLDataUnionOf node) {
        this.sb(node).append("DataUnionOf(");
        node.operands().forEach(r -> {
            r.accept(this);
            this.insertSpace();
        });
        this.closeBracket();
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        this.sb(property).append(this.shortFormProvider.getShortForm(property));
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.sb(axiom).append("AnnotationPropertyDomain(");
        ((OWLAnnotationProperty)axiom.getProperty()).accept(this);
        this.insertSpace();
        ((IRI)axiom.getDomain()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.sb(axiom).append("AnnotationPropertyRange(");
        ((OWLAnnotationProperty)axiom.getProperty()).accept(this);
        this.insertSpace();
        ((IRI)axiom.getRange()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.sb(axiom).append("SubAnnotationPropertyOf(");
        this.writeAnnotations(axiom);
        axiom.getSubProperty().accept(this);
        this.insertSpace();
        axiom.getSuperProperty().accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        this.sb(individual).append(individual.getID());
    }

    @Override
    public void visit(IRI iri) {
        this.sb(iri).append('<').append(iri).append('>');
    }

    @Override
    public void visit(OWLAnnotation node) {
        this.sb(node).append("Annotation(");
        node.annotations().forEach(a -> {
            a.accept(this);
            this.insertSpace();
        });
        node.getProperty().accept(this);
        this.insertSpace();
        node.getValue().accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(SWRLRule rule) {
        this.sb(rule).append("DLSafeRule(");
        this.writeAnnotations(rule);
        this._sb.append(" Body(");
        this.render(rule.body());
        this.closeBracket();
        this._sb.append(" Head(");
        this.render(rule.head());
        this.closeBracket();
        this.closeBracket();
    }

    @Override
    public void visit(SWRLClassAtom node) {
        this.sb(node).append("ClassAtom(");
        node.getPredicate().accept(this);
        this.insertSpace();
        ((SWRLIArgument)node.getArgument()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        this.sb(node).append("DataRangeAtom(");
        node.getPredicate().accept(this);
        this.insertSpace();
        ((SWRLDArgument)node.getArgument()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom node) {
        this.sb(node).append("DifferentFromAtom(");
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.insertSpace();
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(SWRLSameIndividualAtom node) {
        this.sb(node).append("SameAsAtom(");
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.insertSpace();
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        this.sb(node).append("ObjectPropertyAtom(");
        node.getPredicate().accept(this);
        this.insertSpace();
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.insertSpace();
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(SWRLDataPropertyAtom node) {
        this.sb(node).append("DataPropertyAtom(");
        node.getPredicate().accept(this);
        this.insertSpace();
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        this.insertSpace();
        ((SWRLDArgument)node.getSecondArgument()).accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        this.sb(node).append("BuiltInAtom(").append(this.getShortForm(node.getPredicate()));
        this.insertSpace();
        for (SWRLArgument sWRLArgument : node.getArguments()) {
            sWRLArgument.accept(this);
            this.insertSpace();
        }
        this.closeBracket();
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.sb(axiom).append("DatatypeDefinition(");
        this.writeAnnotations(axiom);
        axiom.getDatatype().accept(this);
        this.insertSpace();
        axiom.getDataRange().accept(this);
        this.closeBracket();
    }

    @Override
    public void visit(SWRLVariable node) {
        this.sb(node).append("Variable(");
        this._sb.append(this.getShortForm(node.getIRI()));
        this.closeBracket();
    }

    @Override
    public void visit(SWRLIndividualArgument node) {
        node.getIndividual().accept(this);
    }

    @Override
    public void visit(SWRLLiteralArgument node) {
        node.getLiteral().accept(this);
    }

    public String toString() {
        return this._sb.toString();
    }
}

