/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.Namespaces;

public class NamespaceUtil
implements Serializable {
    private final Map<String, String> namespace2PrefixMap = new HashMap<String, String>();
    private final Map<String, String> standardNamespacePrefixMappings = new HashMap<String, String>();
    private final AtomicInteger candidateIndex = new AtomicInteger(1);

    public NamespaceUtil() {
        this.standardNamespacePrefixMappings.put("http://purl.org/dc/elements/1.1/", "dc");
        this.standardNamespacePrefixMappings.put(Namespaces.SKOS.toString(), "skos");
        this.namespace2PrefixMap.put(Namespaces.OWL.toString(), "owl");
        this.namespace2PrefixMap.put(Namespaces.RDFS.toString(), "rdfs");
        this.namespace2PrefixMap.put(Namespaces.RDF.toString(), "rdf");
        this.namespace2PrefixMap.put(Namespaces.XSD.toString(), "xsd");
    }

    public String getPrefix(String namespace) {
        OWLAPIPreconditions.checkNotNull(namespace, "namespace cannot be null");
        String prefix = this.namespace2PrefixMap.get(namespace);
        if (prefix != null) {
            return prefix;
        }
        prefix = this.generatePrefix(namespace);
        this.namespace2PrefixMap.put(namespace, prefix);
        return prefix;
    }

    public Map<String, String> getNamespace2PrefixMap() {
        return Collections.unmodifiableMap(this.namespace2PrefixMap);
    }

    private String generatePrefix(String namespace) {
        String computedPrefix;
        OWLAPIPreconditions.checkNotNull(namespace, "namespace cannot be null");
        String prefix = this.standardNamespacePrefixMappings.get(namespace);
        if (prefix != null) {
            this.namespace2PrefixMap.put(namespace, prefix);
            return prefix;
        }
        int startIndex = -1;
        for (int i = namespace.length() - 1; i > -1; --i) {
            char curChar = namespace.charAt(i);
            boolean isStartChar = XMLUtils.isNCNameStartChar(curChar);
            if (isStartChar || startIndex == -1) {
                if (!isStartChar) continue;
                startIndex = i;
                continue;
            }
            if (!XMLUtils.isNCNameChar(curChar)) break;
        }
        String candidatePrefix = computedPrefix = this.computePrefix(namespace, startIndex);
        while (this.namespace2PrefixMap.containsValue(candidatePrefix) || this.standardNamespacePrefixMappings.containsValue(candidatePrefix)) {
            candidatePrefix = computedPrefix + this.candidateIndex.getAndIncrement();
        }
        return OWLAPIPreconditions.verifyNotNull(candidatePrefix);
    }

    protected String computePrefix(String namespace, int startIndex) {
        if (startIndex != -1) {
            char curChar;
            int endIndex = startIndex + 1;
            for (int i = startIndex; endIndex < namespace.length() && i < namespace.length() && XMLUtils.isNCNameChar(curChar = namespace.charAt(endIndex)) && curChar != '.'; ++i) {
                endIndex = i + 1;
            }
            return namespace.substring(startIndex, endIndex);
        }
        return "p";
    }

    public void setPrefix(String namespace, String prefix) {
        OWLAPIPreconditions.checkNotNull(namespace, "namespace cannot be null");
        OWLAPIPreconditions.checkNotNull(prefix, "prefix cannot be null");
        this.namespace2PrefixMap.put(namespace, prefix);
    }
}

