/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.util.IRIShortFormProvider;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.StringComparator;
import org.semanticweb.owlapi.util.StringLengthComparator;
import org.semanticweb.owlapi.vocab.Namespaces;

public class DefaultPrefixManager
implements PrefixManager,
ShortFormProvider,
IRIShortFormProvider {
    private final Map<String, String> reverseprefix2NamespaceMap;
    private Map<String, String> prefix2NamespaceMap;
    private StringComparator comparator;

    public DefaultPrefixManager(@Nullable String defaultPrefix) {
        this(null, null, defaultPrefix);
    }

    public DefaultPrefixManager(@Nullable PrefixManager pm, @Nullable StringComparator c, @Nullable String defaultPrefix) {
        this.comparator = c == null ? new StringLengthComparator() : c;
        this.prefix2NamespaceMap = new TreeMap<String, String>(this.comparator);
        this.reverseprefix2NamespaceMap = new TreeMap<String, String>(this.comparator);
        this.setupDefaultPrefixes();
        if (pm != null) {
            this.copyPrefixesFrom(pm);
        }
        if (defaultPrefix != null) {
            this.setDefaultPrefix(defaultPrefix);
        }
    }

    public DefaultPrefixManager() {
        this(null, null, null);
    }

    @Override
    public StringComparator getPrefixComparator() {
        return this.comparator;
    }

    @Override
    public void setPrefixComparator(StringComparator comparator) {
        OWLAPIPreconditions.checkNotNull(comparator, "comparator cannot be null");
        this.comparator = comparator;
        Map<String, String> p = this.prefix2NamespaceMap;
        this.prefix2NamespaceMap = new TreeMap<String, String>(comparator);
        this.prefix2NamespaceMap.putAll(p);
    }

    @Override
    public void clear() {
        this.prefix2NamespaceMap.clear();
        this.reverseprefix2NamespaceMap.clear();
    }

    @Override
    public Stream<String> prefixNames() {
        return this.prefix2NamespaceMap.keySet().stream();
    }

    private void setupDefaultPrefixes() {
        this.setPrefix("owl:", Namespaces.OWL.toString());
        this.setPrefix("rdfs:", Namespaces.RDFS.toString());
        this.setPrefix("rdf:", Namespaces.RDF.toString());
        this.setPrefix("xsd:", Namespaces.XSD.toString());
        this.setPrefix("xml:", Namespaces.XML.toString());
    }

    @Override
    @Nullable
    public String getPrefixIRI(IRI iri) {
        String prefix = this.reverseprefix2NamespaceMap.get(iri.getNamespace());
        if (prefix == null) {
            String iriString = iri.toString();
            String prefixed = null;
            for (String s : this.reverseprefix2NamespaceMap.keySet()) {
                if (!iriString.startsWith(s) || !XMLUtils.isQName(iriString, s.length())) continue;
                prefix = this.reverseprefix2NamespaceMap.get(s);
                prefixed = iriString.replace(s, prefix);
            }
            if (prefixed != null && XMLUtils.isQName(prefixed)) {
                return prefixed;
            }
        }
        if (prefix == null) {
            return null;
        }
        return iri.prefixedBy(prefix);
    }

    @Override
    public String getPrefixIRIIgnoreQName(IRI iri) {
        String prefix = this.reverseprefix2NamespaceMap.get(iri.getNamespace());
        if (prefix == null) {
            String iriString = iri.toString();
            String prefixed = null;
            for (String s : this.reverseprefix2NamespaceMap.keySet()) {
                if (!iriString.startsWith(s) || !XMLUtils.isQName(iriString, s.length())) continue;
                prefix = this.reverseprefix2NamespaceMap.get(s);
                prefixed = iriString.replace(s, prefix);
            }
            if (prefixed != null) {
                return prefixed;
            }
        }
        if (prefix == null) {
            return null;
        }
        return iri.prefixedBy(prefix);
    }

    @Override
    @Nullable
    public String getDefaultPrefix() {
        return this.prefix2NamespaceMap.get(":");
    }

    @Override
    public void setDefaultPrefix(@Nullable String defaultPrefix) {
        String prefixToUnregister = this.prefix2NamespaceMap.get(":");
        if (prefixToUnregister != null) {
            this.prefix2NamespaceMap.remove(":");
            this.reverseprefix2NamespaceMap.remove(prefixToUnregister, ":");
        }
        if (defaultPrefix == null) {
            return;
        }
        this.prefix2NamespaceMap.put(":", defaultPrefix);
        if (!this.reverseprefix2NamespaceMap.containsKey(defaultPrefix)) {
            this.reverseprefix2NamespaceMap.put(defaultPrefix, ":");
        }
    }

    @Override
    public boolean containsPrefixMapping(String prefixName) {
        return this.prefix2NamespaceMap.get(prefixName) != null;
    }

    @Override
    public void copyPrefixesFrom(PrefixManager from) {
        this.copyPrefixesFrom(from.getPrefixName2PrefixMap());
    }

    @Override
    public void copyPrefixesFrom(Map<String, String> from) {
        from.forEach(this::setPrefix);
    }

    @Override
    public IRI getIRI(String prefixIRI) {
        if (prefixIRI.startsWith("<")) {
            return IRI.create(prefixIRI.substring(1, prefixIRI.length() - 1));
        }
        int sep = prefixIRI.indexOf(58);
        if (sep == -1) {
            if (this.getDefaultPrefix() == null) {
                return IRI.create(prefixIRI);
            }
            return IRI.create(this.getDefaultPrefix() + prefixIRI);
        }
        String prefixName = prefixIRI.substring(0, sep + 1);
        if (!this.containsPrefixMapping(prefixName)) {
            throw new OWLRuntimeException("Prefix not registered for prefix name: " + prefixName);
        }
        String prefix = this.getPrefix(prefixName);
        String localName = prefixIRI.substring(sep + 1);
        return IRI.create(prefix, localName);
    }

    @Override
    public Map<String, String> getPrefixName2PrefixMap() {
        return Collections.unmodifiableMap(this.prefix2NamespaceMap);
    }

    @Override
    @Nullable
    public String getPrefix(String prefixName) {
        return this.prefix2NamespaceMap.get(prefixName);
    }

    @Override
    public void setPrefix(String inputPrefixName, String prefix) {
        OWLAPIPreconditions.checkNotNull(inputPrefixName, "prefixName cannot be null");
        OWLAPIPreconditions.checkNotNull(prefix, "prefix cannot be null");
        String _prefixName = inputPrefixName;
        if (!_prefixName.endsWith(":")) {
            _prefixName = _prefixName + ":";
        }
        this.prefix2NamespaceMap.put(_prefixName, prefix);
        this.reverseprefix2NamespaceMap.put(prefix, _prefixName);
    }

    @Override
    public void unregisterNamespace(String namespace) {
        ArrayList toRemove = new ArrayList();
        this.prefix2NamespaceMap.forEach((k, v) -> {
            if (v.equals(namespace)) {
                toRemove.add(k);
            }
        });
        this.reverseprefix2NamespaceMap.remove(namespace);
        this.prefix2NamespaceMap.keySet().removeAll(toRemove);
    }

    @Override
    public String getShortForm(IRI iri) {
        String sf = this.getPrefixIRI(iri);
        if (sf == null) {
            return iri.toQuotedString();
        }
        return sf;
    }

    @Override
    public String getShortForm(OWLEntity entity) {
        return this.getShortForm(entity.getIRI());
    }
}

