/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collection;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.HasComponents;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public abstract class AbstractCollectorEx<E>
implements OWLObjectVisitorEx<Collection<E>> {
    protected Collection<E> objects;

    public AbstractCollectorEx(Collection<E> c) {
        this.objects = OWLAPIPreconditions.checkNotNull(c, "c cannot be null");
    }

    @Override
    public Collection<E> doDefault(Object object) {
        if (object instanceof HasComponents) {
            this.processStream(((HasComponents)object).components());
        }
        return this.objects;
    }

    protected void processStream(Stream<?> s) {
        s.forEach(o -> {
            if (o instanceof OWLObject) {
                ((OWLObject)o).accept(this);
            } else if (o instanceof Stream) {
                this.processStream((Stream)o);
            } else if (o instanceof Collection) {
                this.processStream(((Collection)o).stream());
            }
        });
    }

    public Collection<E> getObjects() {
        return this.objects;
    }
}

