/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasAxioms;
import org.semanticweb.owlapi.model.HasAxiomsByType;
import org.semanticweb.owlapi.model.HasContainsAxiom;
import org.semanticweb.owlapi.model.HasImportsClosure;
import org.semanticweb.owlapi.model.HasLogicalAxioms;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public interface OWLAxiomCollection
extends HasAxioms,
HasLogicalAxioms,
HasAxiomsByType,
HasContainsAxiom,
HasImportsClosure {
    @Deprecated
    default public Set<OWLAxiom> getAxioms(Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.axioms(includeImportsClosure));
    }

    default public Stream<OWLAxiom> axioms(Imports imports) {
        return imports.stream(this).flatMap(HasAxioms::axioms);
    }

    public int getAxiomCount();

    public int getAxiomCount(Imports var1);

    @Deprecated
    default public Set<OWLLogicalAxiom> getLogicalAxioms(Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.logicalAxioms(includeImportsClosure));
    }

    default public Stream<OWLLogicalAxiom> logicalAxioms(Imports imports) {
        return imports.stream(this).flatMap(HasLogicalAxioms::logicalAxioms);
    }

    public int getLogicalAxiomCount();

    public int getLogicalAxiomCount(Imports var1);

    @Deprecated
    default public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType, Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.axioms(axiomType, includeImportsClosure));
    }

    default public <T extends OWLAxiom> Stream<T> axioms(AxiomType<T> axiomType, Imports imports) {
        return imports.stream(this).flatMap(o -> o.axioms(axiomType));
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> var1);

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> var1, Imports var2);

    public boolean containsAxiom(OWLAxiom var1, Imports var2, AxiomAnnotations var3);

    public boolean containsAxiomIgnoreAnnotations(OWLAxiom var1);

    @Deprecated
    default public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom axiom) {
        return OWLAPIStreamUtils.asSet(this.axiomsIgnoreAnnotations(axiom));
    }

    @Deprecated
    default public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom axiom, Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.axiomsIgnoreAnnotations(axiom, includeImportsClosure));
    }

    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom var1);

    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom var1, Imports var2);

    @Deprecated
    default public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlEntity) {
        return OWLAPIStreamUtils.asSet(this.referencingAxioms(owlEntity));
    }

    public Stream<OWLAxiom> referencingAxioms(OWLPrimitive var1);

    @Deprecated
    default public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlEntity, Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.referencingAxioms(owlEntity, includeImportsClosure));
    }

    default public Stream<OWLAxiom> referencingAxioms(OWLPrimitive owlEntity, Imports imports) {
        return imports.stream(this).flatMap(o -> o.referencingAxioms(owlEntity));
    }

    @Deprecated
    default public Set<OWLClassAxiom> getAxioms(OWLClass cls) {
        return OWLAPIStreamUtils.asSet(this.axioms(cls));
    }

    public Stream<OWLClassAxiom> axioms(OWLClass var1);

    @Deprecated
    default public Set<OWLClassAxiom> getAxioms(OWLClass cls, Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.axioms(cls, includeImportsClosure));
    }

    default public Stream<OWLClassAxiom> axioms(OWLClass cls, Imports imports) {
        return imports.stream(this).flatMap(o -> o.axioms(cls));
    }

    @Deprecated
    default public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression property) {
        return OWLAPIStreamUtils.asSet(this.axioms(property));
    }

    public Stream<OWLObjectPropertyAxiom> axioms(OWLObjectPropertyExpression var1);

    @Deprecated
    default public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression property, Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.axioms(property, includeImportsClosure));
    }

    default public Stream<OWLObjectPropertyAxiom> axioms(OWLObjectPropertyExpression property, Imports imports) {
        return imports.stream(this).flatMap(o -> o.axioms(property));
    }

    @Deprecated
    default public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty property) {
        return OWLAPIStreamUtils.asSet(this.axioms(property));
    }

    public Stream<OWLDataPropertyAxiom> axioms(OWLDataProperty var1);

    @Deprecated
    default public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty property, Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.axioms(property, includeImportsClosure));
    }

    default public Stream<OWLDataPropertyAxiom> axioms(OWLDataProperty property, Imports imports) {
        return imports.stream(this).flatMap(o -> o.axioms(property));
    }

    @Deprecated
    default public Set<OWLIndividualAxiom> getAxioms(OWLIndividual individual) {
        return OWLAPIStreamUtils.asSet(this.axioms(individual));
    }

    public Stream<OWLIndividualAxiom> axioms(OWLIndividual var1);

    @Deprecated
    default public Set<OWLIndividualAxiom> getAxioms(OWLIndividual individual, Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.axioms(individual, includeImportsClosure));
    }

    default public Stream<OWLIndividualAxiom> axioms(OWLIndividual individual, Imports imports) {
        return imports.stream(this).flatMap(o -> o.axioms(individual));
    }

    @Deprecated
    default public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty property) {
        return OWLAPIStreamUtils.asSet(this.axioms(property));
    }

    default public Stream<OWLAnnotationAxiom> axioms(OWLAnnotationProperty property) {
        return Stream.of(this.axioms(AxiomType.SUB_ANNOTATION_PROPERTY_OF).filter(a -> a.getSubProperty().equals(property)), this.axioms(AxiomType.ANNOTATION_PROPERTY_RANGE).filter(a -> ((OWLAnnotationProperty)a.getProperty()).equals(property)), this.axioms(AxiomType.ANNOTATION_PROPERTY_DOMAIN).filter(a -> ((OWLAnnotationProperty)a.getProperty()).equals(property))).flatMap(x -> x);
    }

    @Deprecated
    default public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty property, Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.axioms(property, includeImportsClosure));
    }

    default public Stream<OWLAnnotationAxiom> axioms(OWLAnnotationProperty property, Imports imports) {
        return imports.stream(this).flatMap(o -> o.axioms(property));
    }

    @Deprecated
    default public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype datatype) {
        return OWLAPIStreamUtils.asSet(this.axioms(datatype));
    }

    public Stream<OWLDatatypeDefinitionAxiom> axioms(OWLDatatype var1);

    @Deprecated
    default public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype datatype, Imports includeImportsClosure) {
        return OWLAPIStreamUtils.asSet(this.axioms(datatype, includeImportsClosure));
    }

    default public Stream<OWLDatatypeDefinitionAxiom> axioms(OWLDatatype datatype, Imports imports) {
        return imports.stream(this).flatMap(o -> o.datatypeDefinitions(datatype));
    }
}

