/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.Collection;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class RemoveAllDisjointAxioms
extends AbstractCompositeOntologyChange {
    public RemoveAllDisjointAxioms(OWLDataFactory dataFactory, Collection<OWLOntology> ontologies) {
        super(dataFactory);
        this.generateChanges(OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null"));
    }

    private void generateChanges(Collection<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            ont.axioms(AxiomType.DISJOINT_CLASSES).forEach(ax -> this.addChange(new RemoveAxiom(ont, (OWLAxiom)ax)));
        }
    }
}

