/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;

public abstract class OWLDocumentFormatFactoryImpl
implements OWLDocumentFormatFactory {
    private final List<String> mimeTypes;
    private final String key;
    private final boolean isTextualFormat;

    protected OWLDocumentFormatFactoryImpl() {
        this(new ArrayList<String>(0), true);
    }

    protected OWLDocumentFormatFactoryImpl(List<String> mimeTypes) {
        this(mimeTypes, true);
    }

    protected OWLDocumentFormatFactoryImpl(List<String> mimeTypes, boolean isTextualFormat) {
        this.mimeTypes = new ArrayList<String>(mimeTypes);
        this.isTextualFormat = isTextualFormat;
        this.key = this.getClass().getName();
    }

    protected OWLDocumentFormatFactoryImpl(List<String> mimeTypes, boolean isTextualFormat, String key) {
        this.mimeTypes = new ArrayList<String>(mimeTypes);
        this.isTextualFormat = isTextualFormat;
        this.key = key;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public String getDefaultMIMEType() {
        if (this.mimeTypes.isEmpty()) {
            return null;
        }
        return this.mimeTypes.get(0);
    }

    @Override
    public List<String> getMIMETypes() {
        if (this.mimeTypes.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.mimeTypes);
    }

    @Override
    public boolean handlesMimeType(String mimeType) {
        String type = mimeType;
        int semiColon = mimeType.indexOf(59);
        if (semiColon > -1) {
            type = mimeType.substring(0, semiColon);
        }
        for (String nextMimeType : this.getMIMETypes()) {
            if (mimeType.equalsIgnoreCase(nextMimeType)) {
                return true;
            }
            if (mimeType == type || !type.equalsIgnoreCase(nextMimeType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTextual() {
        return this.isTextualFormat;
    }

    public OWLDocumentFormat get() {
        return this.createFormat();
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OWLDocumentFormatFactory)) {
            return false;
        }
        OWLDocumentFormatFactory otherFactory = (OWLDocumentFormatFactory)obj;
        return this.getKey().equals(otherFactory.getKey());
    }
}

