/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Provider;
import org.semanticweb.owlapi.io.OWLObjectRenderer;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.SimpleRenderer;

public final class ToStringRenderer {
    private static final AtomicReference<Provider<OWLObjectRenderer>> rendererProvider = new AtomicReference<Provider>(SimpleRenderer::new);

    public static OWLObjectRenderer getInstance() {
        return (OWLObjectRenderer)rendererProvider.get().get();
    }

    public static void setRenderer(Provider<OWLObjectRenderer> renderer) {
        rendererProvider.set(OWLAPIPreconditions.checkNotNull(renderer, "renderer cannot be null"));
    }

    public static String getRendering(OWLObject object) {
        return ToStringRenderer.getInstance().render(OWLAPIPreconditions.checkNotNull(object, "object cannot be null"));
    }
}

