/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.stream;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;

public final class BinaryOWLStreamUtil {
    protected static int readCollectionSize(DataInput dataInput) throws IOException {
        return BinaryOWLStreamUtil.readVariableLengthUnsignedInt(dataInput);
    }

    protected static void writeCollectionSize(int size, DataOutput dataOutput) throws IOException {
        BinaryOWLStreamUtil.writeVariableLengthUnsignedInt(size, dataOutput);
    }

    public static void writeVariableLengthUnsignedInt(int i, DataOutput dataOutput) throws IOException {
        if (i < 0) {
            throw new RuntimeException("Cannot write int < 0");
        }
        if (i == 0) {
            dataOutput.writeByte(0);
        } else if (i < 127) {
            dataOutput.writeByte(i);
        } else if (i < Short.MAX_VALUE) {
            dataOutput.writeByte(-2);
            dataOutput.writeShort(i);
        } else {
            dataOutput.writeByte(-4);
            dataOutput.writeInt(i);
        }
    }

    public static int readVariableLengthUnsignedInt(DataInput dataInput) throws IOException {
        byte size = dataInput.readByte();
        if (size == 0) {
            return 0;
        }
        if (size == -2) {
            return dataInput.readShort();
        }
        if (size == -4) {
            return dataInput.readInt();
        }
        if (size < 127) {
            return size;
        }
        throw new RuntimeException();
    }

    public static DataInputStream getDataInputStream(InputStream inputStream) {
        DataInputStream dis = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        return dis;
    }

    protected static class ListBackedSet<O>
    extends ArrayList<O>
    implements Set<O> {
        protected ListBackedSet(int initialCapacity) {
            super(initialCapacity);
        }
    }
}

