/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.owlobject.serializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.owlobject.serializer.AbstractAxiomSerializer;
import org.semanticweb.binaryowl.stream.BinaryOWLInputStream;
import org.semanticweb.binaryowl.stream.BinaryOWLOutputStream;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;

public class OWLSubPropertyChainOfAxiomSerializer
extends AbstractAxiomSerializer<OWLSubPropertyChainOfAxiom> {
    @Override
    protected void writeAxiom(OWLSubPropertyChainOfAxiom axiom, BinaryOWLOutputStream outputStream) throws IOException {
        List propertyChain = axiom.getPropertyChain();
        outputStream.writeInt(propertyChain.size());
        for (OWLObjectPropertyExpression propertyExpression : propertyChain) {
            outputStream.writeOWLObject((OWLObject)propertyExpression);
        }
        outputStream.writeOWLObject((OWLObject)axiom.getSuperProperty());
    }

    @Override
    protected OWLSubPropertyChainOfAxiom readAxiom(BinaryOWLInputStream inputStream, Set<OWLAnnotation> annotations) throws IOException, BinaryOWLParseException {
        int size = inputStream.readInt();
        ArrayList<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>(size);
        for (int i = 0; i < size; ++i) {
            OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)inputStream.readOWLObject();
            chain.add(property);
        }
        OWLObjectPropertyExpression superProperty = (OWLObjectPropertyExpression)inputStream.readOWLObject();
        return inputStream.getDataFactory().getOWLSubPropertyChainOfAxiom(chain, superProperty, annotations);
    }
}

