/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.owlobject.serializer;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectSerializer;
import org.semanticweb.binaryowl.stream.BinaryOWLInputStream;
import org.semanticweb.binaryowl.stream.BinaryOWLOutputStream;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class OWLOntologySerializer
extends OWLObjectSerializer<OWLOntology> {
    @Override
    protected void writeObject(OWLOntology object, BinaryOWLOutputStream outputStream) throws IOException {
        OWLOntologyID id = object.getOntologyID();
        if (id.getOntologyIRI().isPresent()) {
            outputStream.writeUTF(((IRI)id.getOntologyIRI().get()).toString());
        } else {
            outputStream.writeUTF("");
        }
        if (id.getVersionIRI().isPresent()) {
            outputStream.writeUTF(((IRI)id.getVersionIRI().get()).toString());
        } else {
            outputStream.writeUTF("");
        }
        HashSet<IRI> importDecls = new HashSet<IRI>();
        for (OWLImportsDeclaration decl : object.getImportsDeclarations()) {
            importDecls.add(decl.getIRI());
        }
        outputStream.writeOWLObjects(importDecls);
        outputStream.writeOWLObjects(object.getAnnotations());
        outputStream.writeOWLObjects(object.getAxioms());
    }

    @Override
    protected OWLOntology readObject(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        try {
            String ontologyIRI = inputStream.readUTF();
            String versionIRI = inputStream.readUTF();
            OWLOntologyID id = ontologyIRI.isEmpty() ? new OWLOntologyID() : (versionIRI.isEmpty() ? new OWLOntologyID(Optional.of((Object)IRI.create((String)ontologyIRI)), Optional.absent()) : new OWLOntologyID(Optional.of((Object)IRI.create((String)ontologyIRI)), Optional.of((Object)IRI.create((String)versionIRI))));
            Set importDecls = inputStream.readOWLObjects();
            Set annotations = inputStream.readOWLObjects();
            Set axioms = inputStream.readOWLObjects();
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            OWLOntology ontology = manager.createOntology(id);
            for (IRI importedIRI : importDecls) {
                OWLImportsDeclaration importDecl = manager.getOWLDataFactory().getOWLImportsDeclaration(importedIRI);
                manager.applyChange((OWLOntologyChange)new AddImport(ontology, importDecl));
            }
            for (OWLAnnotation annotation : annotations) {
                manager.applyChange((OWLOntologyChange)new AddOntologyAnnotation(ontology, annotation));
            }
            manager.addAxioms(ontology, axioms);
            return ontology;
        }
        catch (OWLOntologyCreationException e) {
            throw new RuntimeException(e);
        }
    }
}

