/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.owlobject.serializer;

import java.io.IOException;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.owlobject.serializer.OWLObjectSerializer;
import org.semanticweb.binaryowl.stream.BinaryOWLInputStream;
import org.semanticweb.binaryowl.stream.BinaryOWLOutputStream;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public abstract class OWLObjectCardinalityRestrictionSerializer<R extends OWLObjectCardinalityRestriction>
extends OWLObjectSerializer<R> {
    @Override
    protected void writeObject(R object, BinaryOWLOutputStream outputStream) throws IOException {
        outputStream.writeInt(object.getCardinality());
        outputStream.writeOWLObject((OWLObject)object.getProperty());
        outputStream.writeOWLObject((OWLObject)object.getFiller());
    }

    @Override
    protected R readObject(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        int cardinality = inputStream.readInt();
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)inputStream.readOWLObject();
        OWLClassExpression filler = (OWLClassExpression)inputStream.readOWLObject();
        return this.createRestriction(cardinality, property, filler, inputStream.getDataFactory());
    }

    protected abstract R createRestriction(int var1, OWLObjectPropertyExpression var2, OWLClassExpression var3, OWLDataFactory var4);
}

