/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.owlobject.serializer;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.semanticweb.binaryowl.BinaryOWLParseException;
import org.semanticweb.binaryowl.owlobject.serializer.BinaryOWLImportsDeclaration;
import org.semanticweb.binaryowl.stream.BinaryOWLInputStream;
import org.semanticweb.binaryowl.stream.BinaryOWLOutputStream;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;

public class BinaryOWLImportsDeclarationSet {
    private Set<OWLImportsDeclaration> importsDeclarations;

    public BinaryOWLImportsDeclarationSet(Set<OWLImportsDeclaration> importsDeclarations) {
        this.importsDeclarations = Collections.unmodifiableSet(new LinkedHashSet<OWLImportsDeclaration>(importsDeclarations));
    }

    public BinaryOWLImportsDeclarationSet(BinaryOWLInputStream inputStream) throws IOException, BinaryOWLParseException {
        int size = inputStream.readInt();
        if (size == 0) {
            this.importsDeclarations = Collections.emptySet();
        } else {
            LinkedHashSet<OWLImportsDeclaration> read = new LinkedHashSet<OWLImportsDeclaration>(size);
            for (int i = 0; i < size; ++i) {
                BinaryOWLImportsDeclaration binDecl = new BinaryOWLImportsDeclaration(inputStream);
                read.add(binDecl.getImportsDeclaration());
            }
            this.importsDeclarations = Collections.unmodifiableSet(read);
        }
    }

    public void write(BinaryOWLOutputStream dataOutput) throws IOException {
        dataOutput.writeInt(this.importsDeclarations.size());
        for (OWLImportsDeclaration declaration : this.importsDeclarations) {
            BinaryOWLImportsDeclaration binDecl = new BinaryOWLImportsDeclaration(declaration);
            binDecl.write(dataOutput);
        }
    }

    public Set<OWLImportsDeclaration> getImportsDeclarations() {
        return this.importsDeclarations;
    }
}

