/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.binaryowl.owlapi;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import javax.annotation.Nonnull;
import org.semanticweb.binaryowl.BinaryOWLOntologyDocumentSerializer;
import org.semanticweb.binaryowl.owlapi.BinaryOWLOntologyDocumentFormat;
import org.semanticweb.binaryowl.owlapi.OWLOntologyWrapper;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLStorer;

public class BinaryOWLOntologyDocumentStorer
implements OWLStorer {
    public boolean canStoreOntology(@Nonnull OWLDocumentFormat ontologyFormat) {
        return ontologyFormat instanceof BinaryOWLOntologyDocumentFormat;
    }

    public void storeOntology(@Nonnull OWLOntology ontology, @Nonnull IRI documentIRI, @Nonnull OWLDocumentFormat format) throws OWLOntologyStorageException, IOException {
        URI uri = documentIRI.toURI();
        if (!uri.isAbsolute()) {
            throw new OWLOntologyStorageException("Document IRI is not absolute: " + documentIRI);
        }
        File file = new File(uri);
        this.storeOntology(ontology, new BufferedOutputStream(new FileOutputStream(file)));
    }

    public void storeOntology(@Nonnull OWLOntology ontology, @Nonnull OWLOntologyDocumentTarget target, @Nonnull OWLDocumentFormat format) throws OWLOntologyStorageException, IOException {
        if (!target.isOutputStreamAvailable()) {
            throw new OWLOntologyStorageException("Unsupported target type");
        }
        this.storeOntology(ontology, new BufferedOutputStream(target.getOutputStream()));
    }

    private void storeOntology(OWLOntology ontology, OutputStream os) throws OWLOntologyStorageException, IOException {
        DataOutputStream dos = new DataOutputStream(os);
        BinaryOWLOntologyDocumentSerializer serializer = new BinaryOWLOntologyDocumentSerializer();
        OWLOntologyWrapper doc = new OWLOntologyWrapper(ontology);
        serializer.write(doc, dos);
    }
}

